/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.storage.StorageCheck;
import fr.exemole.bdfserver.api.storage.UiStorage;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.impl.UiComponentsImpl;
import fr.exemole.bdfserver.tools.ui.components.FieldUiBuilder;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeListener;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.html.HtmlCleaner;

class UiManagerImpl
implements UiManager,
FichothequeListener {
    private final BdfServer bdfServer;
    private final UiStorage uiStorage;
    private final Map<SubsetKey, UiComponentsImpl> uiComponentsMap = new HashMap<SubsetKey, UiComponentsImpl>();

    private UiManagerImpl(BdfServer bdfServer, UiStorage uiStorage) {
        this.bdfServer = bdfServer;
        this.uiStorage = uiStorage;
    }

    static UiManagerImpl build(BdfServer bdfServer, UiStorage uiStorage, Map<SubsetKey, StorageCheck.UiCheck> uiCheckMap) {
        UiManagerImpl uiManager = new UiManagerImpl(bdfServer, uiStorage);
        Fichotheque fichotheque = bdfServer.getFichotheque();
        for (Corpus corpus : fichotheque.getCorpusList()) {
            UiComponentsImpl uiComponents = new UiComponentsImpl(corpus);
            StorageCheck.UiCheck uiCheck = uiCheckMap.get(corpus.getSubsetKey());
            if (uiCheck != null) {
                uiComponents.populate(fichotheque, corpus.getCorpusMetadata(), uiCheck.getMainUiComponents());
            }
            uiComponents.checkCorpus();
            uiManager.uiComponentsMap.put(corpus.getSubsetKey(), uiComponents);
        }
        return uiManager;
    }

    @Override
    public HtmlCleaner getHtmlCleaner() {
        return this.uiStorage.getHtmlCleaner();
    }

    @Override
    public UiComponents getMainUiComponents(Corpus corpus) {
        SubsetKey subsetKey = corpus.getSubsetKey();
        UiComponentsImpl uiComponents = this.uiComponentsMap.get(subsetKey);
        if (uiComponents == null) {
            uiComponents = this.addCorpus(corpus);
        }
        return uiComponents;
    }

    void saveUiComponents(UiComponentsImpl uiComponents) {
        this.uiStorage.saveUiComponents(uiComponents.getSubsetKey(), uiComponents);
        this.bdfServer.getTransformationManager().clearDistTransformer();
    }

    @Override
    public void subsetCreated(FichothequeEditor fichothequeEditor, Subset subset) {
        if (subset instanceof Corpus) {
            Corpus corpus = (Corpus)subset;
            this.addCorpus(corpus);
            this.checkMasterSubset(corpus.getMasterSubset());
        }
    }

    @Override
    public void subsetRemoved(FichothequeEditor fichothequeEditor, SubsetKey subsetKey, Subset masterSubset) {
        UiComponentsImpl uiComponents;
        if (subsetKey.isCorpusSubset() && (uiComponents = this.uiComponentsMap.get(subsetKey)) != null) {
            this.uiComponentsMap.remove(subsetKey);
            this.uiStorage.removeUiComponents(subsetKey);
            this.bdfServer.getTransformationManager().clearDistTransformer();
        }
        for (UiComponentsImpl uiComponents2 : this.uiComponentsMap.values()) {
            boolean done = uiComponents2.removeAllSubsetInclude(subsetKey);
            if (!done) continue;
            this.saveUiComponents(uiComponents2);
        }
    }

    @Override
    public void subsetItemRemoved(FichothequeEditor fichothequeEditor, Subset subset, int id) {
    }

    @Override
    public void corpusFieldCreated(FichothequeEditor fichothequeEditor, Corpus corpus, CorpusField corpusField) {
        FieldKey fieldKey = corpusField.getFieldKey();
        UiComponentsImpl uiComponents = this.uiComponentsMap.get(corpus.getSubsetKey());
        if (uiComponents != null) {
            uiComponents.add(FieldUiBuilder.init(fieldKey).toFieldUi());
            this.saveUiComponents(uiComponents);
        }
    }

    @Override
    public void corpusFieldRemoved(FichothequeEditor fichothequeEditor, Corpus corpus, FieldKey fieldKey) {
        boolean done;
        UiComponentsImpl uiComponents = this.uiComponentsMap.get(corpus.getSubsetKey());
        if (uiComponents != null && (done = uiComponents.removeComponentUi(fieldKey.getKeyString(), true))) {
            this.saveUiComponents(uiComponents);
        }
    }

    @Override
    public void ficheSaved(FichothequeEditor fichothequeEditor, FicheMeta ficheMeta, FicheAPI fiche) {
    }

    @Override
    public void subsetItemCreated(FichothequeEditor fichothequeEditor, SubsetItem subsetItem) {
    }

    private UiComponentsImpl addCorpus(Corpus corpus) {
        UiComponentsImpl uiComponents = new UiComponentsImpl(corpus);
        uiComponents.checkCorpus();
        uiComponents.checkParentage();
        uiComponents.checkSpecialIncludeUi("liage");
        this.uiComponentsMap.put(corpus.getSubsetKey(), uiComponents);
        return uiComponents;
    }

    private void checkMasterSubset(Subset masterSubset) {
        boolean done;
        UiComponentsImpl uiComponents;
        if (masterSubset == null) {
            return;
        }
        if (masterSubset instanceof Corpus && (uiComponents = this.uiComponentsMap.get(masterSubset.getSubsetKey())) != null && (done = uiComponents.checkParentage())) {
            this.saveUiComponents(uiComponents);
        }
    }
}

