/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.forms.TableExportFormHtml;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.exportation.table.FicheTableParametersBuilder;
import fr.exemole.bdfserver.tools.exportation.table.TableExportParametersBuilder;
import java.util.List;
import java.util.Map;
import net.fichotheque.exportation.table.TableExportConstants;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.selection.SelectionDef;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.text.StringUtils;

public class TableExportFormHtmlProducer
extends BdfServerHtmlProducer {
    private static final SelectOption EMPTY_OPTION = SelectOption.init("").text("---");
    private final TableExportManager tableExportManager;

    public TableExportFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.tableExportManager = this.bdfServer.getTableExportManager();
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addThemeCss("misc.css");
    }

    @Override
    public void printHtml() {
        Map<String, String> storeMap = this.getStoredValues("form_tableexport");
        TableExportParameters tableExportParameters = this.initTableExportParameters(this.bdfUser.getPrefs(), storeMap);
        this.start();
        this.__(PageUnit.start("action-Ods", "_ title.tableexport.stream")).FORM_get(HA.action("tables/get-multi").attr("data-formstorage-key", "tableExportForm")).__(this.printTableExportChoice(tableExportParameters, storeMap)).__(TableExportFormHtml.HEADERTYPE_TITLE).__(TableExportFormHtml.printHeaderTypeRadios(this, tableExportParameters.getHeaderType())).__(this.printSelectionFilter(storeMap)).__(this.printSpreadMerge(storeMap)).__(Button.COMMAND, Button.submit("action-Ods", "_ submit.tableexport.stream_ods"))._FORM().__(PageUnit.END);
        this.end();
    }

    private boolean printTableExportChoice(TableExportParameters tableExportParameters, Map<String, String> storeMap) {
        String defaultDivId = this.generateId();
        String nameDivId = this.generateId();
        List<TableExportDescription> tableExportDescriptionList = this.tableExportManager.getValidTableExportDescriptionList();
        if (!tableExportDescriptionList.isEmpty()) {
            String tableExportName = tableExportParameters.getTableExportName();
            boolean isDefault = tableExportName == null;
            this.__(Grid.START).__(Grid.radioRow((Object)"_ label.tableexport.tableexport_name", this.name("defaultexport").value("0").checked(!isDefault).populate(Deploy.radio(nameDivId)), () -> this.DIV(Grid.detailPanelTable().id(nameDivId).addClass(isDefault, "hidden")).__(Grid.selectRow((Object)"_ label.global.tableexport", this.name("tableexport"), () -> {
                for (TableExportDescription current : tableExportDescriptionList) {
                    String title;
                    String currentName = current.getName();
                    boolean selected = false;
                    if (tableExportName != null && currentName.equals(tableExportName)) {
                        selected = true;
                    }
                    title = (title = current.getTitle(this.workingLang)).equals(currentName) ? "" : " " + title;
                    this.OPTION(currentName, selected).__escape("[").__escape(currentName).__escape("]").__escape(title)._OPTION();
                }
            })).__(Grid.checkboxRow("_ label.tableexport.withthesaurustable", this.name("thesaurustable").value("1").checked(storeMap)))._DIV())).__(Grid.radioRow((Object)"_ label.tableexport.tableexport_default", this.name("defaultexport").value("1").checked(isDefault).populate(Deploy.radio(defaultDivId)), () -> this.DIV(HA.id(defaultDivId).classes("global-DetailPanel").addClass(!isDefault, "hidden")).__(TableExportFormHtml.printWithParameters(this, tableExportParameters.getDefaulFicheTableParameters())).__(TableExportFormHtml.printPatternModeRadios(this, tableExportParameters.getDefaulFicheTableParameters().getPatternMode()))._DIV())).__(Grid.END);
        } else {
            this.__(TableExportFormHtml.printWithParameters(this, tableExportParameters.getDefaulFicheTableParameters())).__(TableExportFormHtml.printPatternModeRadios(this, tableExportParameters.getDefaulFicheTableParameters().getPatternMode()));
        }
        return true;
    }

    private boolean printSpreadMerge(Map<String, String> storeMap) {
        this.__(Grid.START).__(Grid.checkboxRow("_ label.tableexport.spreadsheetmerge", this.name("merge").value("1").checked(storeMap))).__(Grid.END);
        return true;
    }

    private boolean printSelectionFilter(Map<String, String> storeMap) {
        List<SelectionDef> selectionDefList = this.bdfServer.getSelectionManager().getSelectionDefList();
        if (selectionDefList.isEmpty()) {
            return false;
        }
        List<SelectOption> optionList = BdfHtmlUtils.toAvailableOptionList(selectionDefList, this.workingLang);
        if (optionList.isEmpty()) {
            return false;
        }
        optionList.add(0, EMPTY_OPTION);
        String current = storeMap.get("selection");
        if (current == null) {
            current = "";
        }
        this.__(Grid.START).__(Grid.selectRow((Object)"_ label.tableexport.selectionfilter", this.name("selection"), SelectOption.consumer(optionList, (Object)current))).__(Grid.END);
        return true;
    }

    private TableExportParameters initTableExportParameters(BdfUserPrefs prefs, Map<String, String> storeMap) {
        Parser parser = new Parser(prefs, storeMap);
        return parser.init();
    }

    private static class Parser {
        private final BdfUserPrefs prefs;
        private final TableExportParametersBuilder builder;
        private final Map<String, String> storeMap;

        private Parser(BdfUserPrefs prefs, Map<String, String> storeMap) {
            this.prefs = prefs;
            this.storeMap = storeMap;
            this.builder = new TableExportParametersBuilder();
        }

        private TableExportParameters init() {
            return TableExportParametersBuilder.init().setTableExportName(this.initTableExportName()).setFicheTableParameters(this.initFicheTableParameters()).setHeaderType(this.initHeaderType()).toTableExportParameters();
        }

        private String initTableExportName() {
            String defaultExport = this.storeMap.get("defaultexport");
            if (defaultExport != null && defaultExport.equals("0")) {
                return this.storeMap.get("tableexport");
            }
            return null;
        }

        private String initHeaderType() {
            String headerType = this.storeMap.get("headertype");
            if (headerType == null) {
                return this.prefs.getDefaultHeaderType();
            }
            try {
                return TableExportConstants.checkHeaderType(headerType);
            }
            catch (IllegalArgumentException iae) {
                return this.prefs.getDefaultHeaderType();
            }
        }

        private FicheTableParameters initFicheTableParameters() {
            String patternMode = this.storeMap.get("patternmode");
            if (patternMode == null) {
                return this.prefs.getDefaultFicheTableParameters();
            }
            FicheTableParametersBuilder ficheTableParametersBuilder = new FicheTableParametersBuilder();
            try {
                ficheTableParametersBuilder.setPatternMode(patternMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String withString = this.storeMap.get("with");
            if (withString != null) {
                String[] tokens;
                for (String token : tokens = StringUtils.getTokens(withString, ';', (short)2)) {
                    ficheTableParametersBuilder.putWith(token);
                }
            }
            return ficheTableParametersBuilder.toFicheTableParameters();
        }
    }
}

