/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaHtmlUtils;
import java.util.List;
import net.fichotheque.addenda.Document;
import net.fichotheque.croisement.CroisementsBySubset;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.PermissionSubsetEligibility;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.html.CommandBox;

public class DocumentAdminFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Document document;
    private final PermissionSummary permissionSummary;
    private final boolean isSubsetAdmin;

    public DocumentAdminFormHtmlProducer(BdfParameters bdfParameters, Document document) {
        super(bdfParameters);
        this.document = document;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(document.getSubsetKey());
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss("addenda.css");
    }

    @Override
    public void printHtml() {
        PermissionSubsetEligibility subsetEligibity = PermissionSubsetEligibility.read(this.permissionSummary);
        List<CroisementsBySubset> croisementsBySubsetList = CroisementUtils.filterCroisements(this.document, subsetEligibity, (short)1);
        this.start();
        AddendaHtmlUtils.printDocumentToolbar(this, "document-adminform", this.document, this.isSubsetAdmin);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("addenda").family("ADD").veil(true).page("document-adminform");
        AddendaCommandBoxUtils.printDocumentNameChangeBox(this, commandBox, this.document, this.workingLang);
        if (!croisementsBySubsetList.isEmpty()) {
            AddendaCommandBoxUtils.printCroisementRemoveBox(this, commandBox, this.document, croisementsBySubsetList, this.permissionSummary, this.bdfUser);
        }
        AddendaCommandBoxUtils.printCroisementAddBox(this, commandBox, this.document);
        commandBox.errorPage("document-adminform").page("_message");
        AddendaCommandBoxUtils.printDocumentRemoveBox(this, commandBox, this.document);
        this.end();
    }
}

