/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.BH;
import java.text.MessageFormat;
import java.util.List;
import java.util.TreeMap;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.permission.PermissionEntry;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.ListFilterEngine;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlWrapper;

public class AddendaHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper VERSION_TREE = Tree.tree("addenda-VersionTree");
    private static final HtmlWrapper VERSION_LEAF = Tree.tree("addenda-VersionLeaf");
    private final PermissionSummary permissionSummary;
    private final Addenda addenda;
    private final boolean isSubsetAdmin;
    private final MessageFormat idFormat;
    private final Button linkButton = Button.link();

    public AddendaHtmlProducer(BdfParameters bdfParameters, Addenda addenda) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.addenda = addenda;
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(addenda.getSubsetKey());
        this.idFormat = new MessageFormat(this.getLocalization("_ info.main.documentnumber"), this.getFormatLocale());
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addThemeCss("addenda.css");
        this.setBodyCssClass("global-body-ListFrame");
    }

    @Override
    public void printHtml() {
        int count;
        List<PermissionEntry> permissionEntryList;
        List<SubsetItem> documentList = this.addenda.getSubsetItemList();
        if (!documentList.isEmpty()) {
            permissionEntryList = ListFilterEngine.filter(this.addenda, documentList, this.permissionSummary);
            count = permissionEntryList.size();
        } else {
            permissionEntryList = null;
            count = 0;
        }
        this.start(FichothequeUtils.getTitle(this.addenda, this.workingLang), true);
        this.__(BdfHtmlUtils.startSubsetUnit(this, this.bdfParameters, this.addenda, "addenda")).__(this.printCommands()).__(PageUnit.END);
        if (count > 0) {
            this.__(PageUnit.start().sectionCss("unit-Unit addenda-DocumentListUnit").title(() -> this.__localize("_ title.addenda.documents").__space().__(BdfHtmlUtils.printItemCount(this, this.bdfUser, count)))).UL("subsetitem-List").__(this.printDocumentList(permissionEntryList))._UL().__(PageUnit.END);
        }
        this.end();
    }

    private boolean printCommands() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        this.DETAILS(HA.id("details_commands").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.link("action-Metadata", "addenda-metadataform", "_ link.addenda.addendametadataform")).__(this.link("action-Advanced", "addenda-advancedcommands", "_ link.addenda.addendaadvancedcommands")).__(this.link("action-Refresh", "addenda", "_ link.global.reload"))._DIV()._DETAILS();
        return true;
    }

    private Button link(String action, String page, String messageKey) {
        String href = BH.domain("addenda").subset(this.addenda).page(page).toString();
        String target = page.equals("addenda") ? null : "Edition";
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target(target);
    }

    private boolean printDocumentList(List<PermissionEntry> entryList) {
        TreeMap<String, PermissionEntry> sortMap = new TreeMap<String, PermissionEntry>();
        for (PermissionEntry entry : entryList) {
            sortMap.put(((Document)entry.getSubsetItem()).getBasename(), entry);
        }
        for (PermissionEntry permissionEntry : sortMap.values()) {
            this.LI().__(this.printDocument((Document)permissionEntry.getSubsetItem(), permissionEntry.isEditable()))._LI();
        }
        return true;
    }

    private boolean printDocument(Document document, boolean editable) {
        String basename = document.getBasename();
        Object[] objs = new Object[]{document.getId()};
        this.DIV("subsetitem-Title").P().__escape(basename)._P().__(this.printDocumentEdit(editable, document))._DIV().DIV("subsetitem-Infos").__escape(this.idFormat.format(objs))._DIV().__(VERSION_TREE, () -> {
            for (Version version : document.getVersionList()) {
                String extension = version.getExtension();
                this.__(VERSION_LEAF, () -> this.A(HA.href("documents/" + this.addenda.getSubsetName() + "/" + basename + "." + extension).target("_blank")).__escape('.').__escape(extension)._A().SPAN("addenda-Size").__space().__escape('(').__(BdfHtmlUtils.printDocumentVersionSize(this, version, this.getFormatLocale())).__escape(')')._SPAN());
            }
        });
        return true;
    }

    private boolean printDocumentEdit(boolean editable, Document document) {
        if (!editable) {
            return false;
        }
        this.A(HA.href(BH.domain("addenda").subsetItem(document).page("document-adminform")).target("Edition").classes("button-Circle action-DocumentEdit")).__(Button.ICON)._A();
        return true;
    }
}

