/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions.tables;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.get.streamproducers.TableExportOdsProducer;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.exportation.table.TableExportParametersBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.tools.exportation.table.TableExportOdsParameters;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;

public class MultiTableExportEngine {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final BdfParameters bdfParameters;
    private final TableExportParameters tableExportParameters;
    private final boolean merge;
    private final boolean withThesaurusTable;
    private final SelectionDef filterSelectionDef;

    private MultiTableExportEngine(BdfParameters bdfParameters, TableExportParameters tableExportParameters, boolean merge, boolean withThesaurusTable, SelectionDef filterSelectionDef) {
        this.bdfParameters = bdfParameters;
        this.tableExportParameters = tableExportParameters;
        this.merge = merge;
        this.withThesaurusTable = withThesaurusTable;
        this.filterSelectionDef = filterSelectionDef;
    }

    public ResponseHandler run() {
        BdfServer bdfServer = this.bdfParameters.getBdfServer();
        String fileName = this.getFileName();
        TableExport tableExport = this.getTableExport();
        Predicate<SubsetItem> globalPredicate = this.getGlobalPredicate();
        TableExportContext tableExportContext = bdfServer.getTableExportContext();
        ExtractionContext extractionContext = this.bdfParameters.getDefaultExtractionContext();
        SumCellConverter cellConverter = BdfTableExportUtils.toCellConverter(bdfServer, extractionContext, tableExport, globalPredicate);
        TableExportOdsParameters tableExportOdsParameters = TableExportOdsParameters.init(tableExportContext, this.bdfParameters.getWorkingLang()).setSumCellConverter(cellConverter).setHeaderType(this.tableExportParameters.getHeaderType()).setWithThesaurusTable(this.withThesaurusTable);
        TableExportOdsProducer streamProducer = TableExportOdsProducer.newMultiInstance(fileName, this.bdfParameters, tableExport, this.bdfParameters.getBdfUser().getSelectedFiches(), this.merge, tableExportOdsParameters);
        return StreamResponseHandler.init(streamProducer);
    }

    private Predicate<SubsetItem> getGlobalPredicate() {
        if (this.filterSelectionDef == null) {
            return null;
        }
        return BdfServerUtils.toPredicate(this.bdfParameters, this.filterSelectionDef.getFichothequeQueries());
    }

    private TableExport getTableExport() {
        BdfServer bdfServer = this.bdfParameters.getBdfServer();
        PermissionSummary permissionSummary = this.bdfParameters.getPermissionSummary();
        String tableExportName = this.tableExportParameters.getTableExportName();
        if (tableExportName == null) {
            return BdfTableExportUtils.toDefaultTableExport(bdfServer, this.tableExportParameters.getDefaulFicheTableParameters(), permissionSummary);
        }
        return bdfServer.getTableExportManager().getTableExport(tableExportName);
    }

    private String getFileName() {
        BdfServer bdfServer = this.bdfParameters.getBdfServer();
        StringBuilder buf = new StringBuilder();
        buf.append("tableexport-");
        buf.append(bdfServer.getFichotheque().getFichothequeMetadata().getBaseName());
        String tableExportName = this.tableExportParameters.getTableExportName();
        if (tableExportName != null) {
            if (bdfServer.getTableExportManager().containsTableExport(tableExportName)) {
                buf.append("-");
                buf.append(tableExportName);
            } else {
                tableExportName = null;
            }
        }
        buf.append(".");
        buf.append(dateFormat.format(new Date()));
        buf.append(".ods");
        return buf.toString();
    }

    public static MultiTableExportEngine buildFromRequest(BdfParameters bdfParameters, RequestMap requestMap) throws ErrorMessageException {
        RequestHandler requestHandler = RequestHandler.init(bdfParameters, requestMap).enableStore();
        TableExportParameters tableExportParameters = MultiTableExportEngine.getTableExportParameters(requestHandler);
        boolean merge = requestHandler.isTrue("merge");
        boolean withThesaurusTable = requestHandler.isTrue("thesaurustable");
        SelectionDef filterSelectionDef = null;
        String selectionParamName = requestHandler.getTrimedParameter("selection");
        if (!selectionParamName.isEmpty()) {
            filterSelectionDef = requestHandler.getMandatorySelectionDef();
        }
        requestHandler.store("form_tableexport");
        return new MultiTableExportEngine(bdfParameters, tableExportParameters, merge, withThesaurusTable, filterSelectionDef);
    }

    private static TableExportParameters getTableExportParameters(RequestHandler requestHandler) throws ErrorMessageException {
        String tableExportName;
        TableExportParametersBuilder tableExportParametersBuilder = TableExportParametersBuilder.init().setFicheTableParameters(requestHandler.getFicheTableParameters()).setHeaderType(requestHandler.getHeaderType());
        String defaultExportParam = requestHandler.getTrimedParameter("defaultexport");
        if (defaultExportParam.equals("0") && !(tableExportName = requestHandler.getTrimedParameter("tableexport")).isEmpty()) {
            boolean present = requestHandler.getBdfServer().getTableExportManager().containsTableExport(tableExportName);
            if (!present) {
                throw BdfErrors.unknownParameterValue("tableexport", tableExportName);
            }
            tableExportParametersBuilder.setTableExportName(tableExportName);
        }
        return tableExportParametersBuilder.toTableExportParameters();
    }
}

