/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.IllustrationStreamProducer;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.handlers.RedirectResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;

public class IllustrationsInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String filePath;

    public IllustrationsInstruction(BdfServer bdfServer, String filePath) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        short formatType;
        int illustrationid;
        SubsetKey albumKey;
        String illustrationName;
        int idx1 = this.filePath.indexOf(47);
        String dimString = null;
        if (idx1 != -1) {
            if (this.filePath.indexOf(47, idx1 + 1) != -1) {
                return null;
            }
            dimString = this.filePath.substring(0, idx1);
            illustrationName = this.filePath.substring(idx1 + 1);
        } else {
            illustrationName = this.filePath;
        }
        int idx2 = illustrationName.indexOf(45);
        if (idx2 == -1) {
            return null;
        }
        int idx3 = illustrationName.indexOf(46);
        if (idx3 == -1) {
            return null;
        }
        if (idx3 < idx2) {
            return null;
        }
        try {
            albumKey = SubsetKey.parse((short)5, illustrationName.substring(0, idx2));
        }
        catch (ParseException pe) {
            return null;
        }
        try {
            illustrationid = Integer.parseInt(illustrationName.substring(idx2 + 1, idx3));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            formatType = AlbumUtils.formatTypeToShort(illustrationName.substring(idx3 + 1));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        Album album = (Album)this.bdfServer.getFichotheque().getSubset(albumKey);
        if (album == null) {
            return null;
        }
        PermissionSummary permissionSummary = PermissionSummaryBuilder.build(this.bdfServer, bdfUser);
        if (!permissionSummary.hasAccess(album)) {
            throw new ForbiddenException();
        }
        Illustration illustration = album.getIllustrationById(illustrationid);
        if (illustration == null) {
            return null;
        }
        AlbumDim albumDim = null;
        short specialDim = 0;
        if (dimString == null) {
            specialDim = 202;
        } else if (dimString.equals("_mini")) {
            specialDim = 201;
        } else {
            albumDim = album.getAlbumMetadata().getAlbumDimByName(dimString);
            if (albumDim == null) {
                return null;
            }
        }
        if (illustration.getFormatType() != formatType) {
            return new RedirectResponseHandler(illustration.getFileName());
        }
        IllustrationStreamProducer illustrationStreamProducer = albumDim != null ? new IllustrationStreamProducer(null, illustration, albumDim) : new IllustrationStreamProducer(null, illustration, specialDim);
        return StreamResponseHandler.init(illustrationStreamProducer);
    }
}

