/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.FicheAttachmentParameters;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.email.TableExportEmail;
import fr.exemole.bdfserver.email.ValidAddress;
import fr.exemole.bdfserver.email.WrongAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.text.StringUtils;

public class EmailBuffer {
    public static final String TO_FIELD = "to";
    public static final String CC_FIELD = "cc";
    public static final String BCC_FIELD = "bcc";
    public static final String REPLYTO_FIELD = "replyto";
    private static final List<WrongAddress> EMPTY_WRONGLIST = Collections.emptyList();
    private static final List<ValidAddress> EMPTY_VALIDLIST = Collections.emptyList();
    private final EmailCore redacteurEmail;
    private final EmailCore fromEmail;
    private final Map<String, EmailCore> replytoMap = new LinkedHashMap<String, EmailCore>();
    private final String sendType;
    private final Object sendObject;
    private final Map<String, List<ValidAddress>> validMap = new HashMap<String, List<ValidAddress>>();
    private final Map<String, List<WrongAddress>> wrongMap = new HashMap<String, List<WrongAddress>>();
    private boolean withRedacteurBcc;
    private boolean withRedacteurReplyTo;
    private String subject;
    private String message;
    private FicheAttachmentParameters ficheAttachmentParameters = EmailBuffer.getDefaultFicheAttachmentParameters();

    public EmailBuffer(EmailCore redacteurEmail, EmailCore fromEmail, String sendType, Object sendObject) {
        this.redacteurEmail = redacteurEmail;
        this.fromEmail = fromEmail;
        this.sendType = sendType;
        this.sendObject = sendObject;
    }

    public String getSendType() {
        return this.sendType;
    }

    @Nullable
    public Object getSendObject() {
        return this.sendObject;
    }

    public boolean isWithRedacteurBcc() {
        return this.withRedacteurBcc;
    }

    public EmailBuffer setWithRedacteurBcc(boolean withRedacteurBcc) {
        this.withRedacteurBcc = withRedacteurBcc;
        return this;
    }

    public boolean isWithRedacteurReplyTo() {
        return this.withRedacteurBcc;
    }

    public EmailBuffer setWithRedacteurReplyTo(boolean withRedacteurReplyTo) {
        this.withRedacteurReplyTo = withRedacteurReplyTo;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public EmailBuffer setSubject(String subject) {
        if (subject != null && (subject = StringUtils.cleanString(subject)).length() == 0) {
            subject = null;
        }
        this.subject = subject;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public EmailBuffer setMessage(String message) {
        if (message != null && (message = message.trim()).length() == 0) {
            message = null;
        }
        this.message = message;
        return this;
    }

    public boolean isWithoutField(String fieldName) {
        return !this.validMap.containsKey(fieldName) && !this.wrongMap.containsKey(fieldName);
    }

    public boolean hasWrongAddresses() {
        return !this.wrongMap.isEmpty();
    }

    public List<WrongAddress> getWrongAddressList(String fieldName) {
        List<WrongAddress> list = this.wrongMap.get(fieldName);
        if (list == null) {
            return EMPTY_WRONGLIST;
        }
        return list;
    }

    public List<ValidAddress> getValidAddressList(String fieldName) {
        List<ValidAddress> list = this.validMap.get(fieldName);
        if (list == null) {
            return EMPTY_VALIDLIST;
        }
        return list;
    }

    public EmailBuffer addValidAddress(String fieldName, ValidAddress validAddress) {
        List<ValidAddress> list = this.validMap.get(fieldName);
        if (list == null) {
            list = new ArrayList<ValidAddress>();
            this.validMap.put(fieldName, list);
        }
        list.add(validAddress);
        return this;
    }

    public EmailBuffer addWrongAddress(String fieldName, WrongAddress wrongAddress) {
        List<WrongAddress> list = this.wrongMap.get(fieldName);
        if (list == null) {
            list = new ArrayList<WrongAddress>();
            this.wrongMap.put(fieldName, list);
        }
        list.add(wrongAddress);
        return this;
    }

    public EmailBuffer parseToArray(Fichotheque fichotheque, String fieldName, List<String> valueList, SubsetKey defaultSphereKey) {
        for (String value : valueList) {
            int idx = value.indexOf(64);
            if (idx == -1) {
                try {
                    Redacteur redacteur = SphereUtils.parse(fichotheque, value, defaultSphereKey);
                    EmailCore emailCore = redacteur.getEmailCore();
                    if (emailCore == null) {
                        this.addWrongAddress(fieldName, WrongAddress.redacteurNoAdressError(value));
                        continue;
                    }
                    this.addValidAddress(fieldName, new ValidAddress(emailCore, value));
                }
                catch (SphereUtils.RedacteurLoginException rle) {
                    this.addWrongAddress(fieldName, WrongAddress.redacteurUnknownError(value));
                }
                continue;
            }
            try {
                EmailCore emailCore = EmailCoreUtils.parse(value);
                this.addValidAddress(fieldName, new ValidAddress(emailCore, value));
            }
            catch (ParseException pe2) {
                this.addWrongAddress(fieldName, WrongAddress.malformedAddressError(value));
            }
        }
        return this;
    }

    public EmailCore getFromEmail() {
        return this.fromEmail;
    }

    public EmailCore getRedacteurEmail() {
        return this.redacteurEmail;
    }

    public Collection<EmailCore> getReplytoCollection() {
        ArrayList<EmailCore> list = new ArrayList<EmailCore>();
        for (ValidAddress validAddress : this.getValidAddressList(REPLYTO_FIELD)) {
            list.add(validAddress.getEmailCore());
        }
        if (this.withRedacteurReplyTo) {
            list.add(this.redacteurEmail);
        }
        return list;
    }

    public Collection<EmailCore> getToCollection() {
        ArrayList<EmailCore> list = new ArrayList<EmailCore>();
        for (ValidAddress validAddress : this.getValidAddressList(TO_FIELD)) {
            list.add(validAddress.getEmailCore());
        }
        return list;
    }

    public Collection<EmailCore> getCcCollection() {
        ArrayList<EmailCore> list = new ArrayList<EmailCore>();
        for (ValidAddress validAddress : this.getValidAddressList(CC_FIELD)) {
            list.add(validAddress.getEmailCore());
        }
        return list;
    }

    public Collection<EmailCore> getBccCollection() {
        ArrayList<EmailCore> list = new ArrayList<EmailCore>();
        for (ValidAddress validAddress : this.getValidAddressList(BCC_FIELD)) {
            list.add(validAddress.getEmailCore());
        }
        if (this.withRedacteurBcc) {
            list.add(this.redacteurEmail);
        }
        return list;
    }

    public FicheAttachmentParameters getFicheAttachmentParameters() {
        return this.ficheAttachmentParameters;
    }

    public EmailBuffer setFicheAttachmentParameters(FicheAttachmentParameters ficheAttachmentParameters) {
        this.ficheAttachmentParameters = ficheAttachmentParameters == null ? EmailBuffer.getDefaultFicheAttachmentParameters() : ficheAttachmentParameters;
        return this;
    }

    public static EmailBuffer buildForFiche(BdfServer bdfServer, BdfUser bdfUser, FicheMeta ficheMeta) {
        if (ficheMeta == null) {
            throw new IllegalArgumentException("ficheMeta is  null");
        }
        return EmailBuffer.build(bdfServer, bdfUser, "fiche", ficheMeta);
    }

    public static EmailBuffer buildForCompilation(BdfServer bdfServer, BdfUser bdfUser) {
        return EmailBuffer.build(bdfServer, bdfUser, "compilation", null);
    }

    public static EmailBuffer buildForSelection(BdfServer bdfServer, BdfUser bdfUser, Set<FicheMeta> ficheMetaSet) {
        return EmailBuffer.build(bdfServer, bdfUser, "selection", ficheMetaSet);
    }

    public static EmailBuffer buildForTableExport(BdfServer bdfServer, BdfUser bdfUser, TableExportEmail tableExportEmail) {
        return EmailBuffer.build(bdfServer, bdfUser, "tableexport", tableExportEmail);
    }

    public static EmailBuffer build(BdfServer bdfServer, BdfUser bdfUser, String sendType, Object sendObject) {
        Redacteur redacteur = bdfUser.getRedacteur();
        EmailCore redacteurEmail = redacteur.getEmailCore();
        if (redacteurEmail == null) {
            throw new IllegalArgumentException("bdfUser.getRedacteur().getEmailCore() is null");
        }
        boolean redacteurReplyTo = false;
        EmailCore fromEmail = redacteurEmail;
        if (!EmailBuffer.isSelfFrom(redacteur)) {
            EmailCore customFrom = EmailBuffer.getCustomFrom(redacteur);
            if (customFrom != null) {
                if (customFrom.getComputedRealName().isEmpty()) {
                    customFrom = EmailCoreUtils.derive(customFrom, redacteurEmail.getComputedRealName());
                }
                fromEmail = customFrom;
                redacteurReplyTo = true;
            } else {
                SmtpManager smtpManager = (SmtpManager)bdfServer.getContextObject("smtpManager");
                EmailCore defaultFrom = smtpManager.getSmtpParameters().getDefaultFrom();
                if (defaultFrom != null) {
                    fromEmail = EmailCoreUtils.derive(defaultFrom, redacteurEmail.getComputedRealName());
                    redacteurReplyTo = true;
                }
            }
        }
        return EmailBuffer.init(redacteurEmail, fromEmail, sendType, sendObject).setWithRedacteurReplyTo(redacteurReplyTo);
    }

    public static EmailBuffer init(EmailCore redacteurEmail, EmailCore fromEmail, String sendType, Object sendObject) {
        return new EmailBuffer(redacteurEmail, fromEmail, sendType, sendObject);
    }

    private static boolean isSelfFrom(Redacteur redacteur) {
        Attribute attribute = redacteur.getAttributes().getAttribute(BdfSpace.SENDPOLICY_KEY);
        if (attribute != null) {
            return attribute.getFirstValue().equals("selffrom");
        }
        return false;
    }

    private static EmailCore getCustomFrom(Redacteur redacteur) {
        Attribute attribute = redacteur.getAttributes().getAttribute(BdfSpace.SENDPOLICY_KEY);
        if (attribute != null && attribute.size() > 1 && attribute.getFirstValue().equals("from")) {
            try {
                EmailCore email = EmailCoreUtils.parse((String)attribute.get(1));
                return email;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static FicheAttachmentParameters getDefaultFicheAttachmentParameters() {
        FicheAttachmentParameters ficheAttachmentParameters = new FicheAttachmentParameters();
        ficheAttachmentParameters.setWithHtml(true);
        return ficheAttachmentParameters;
    }
}

