/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.commands.AbstractPhrasesCommand;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusPhrasesCommand
extends AbstractPhrasesCommand {
    public static final String COMMANDNAME = "ThesaurusPhrases";
    public static final String COMMANDKEY = "_ THS-02";
    private Thesaurus thesaurus;

    public ThesaurusPhrasesCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusMetadataEditor thesaurusMetadataEditor = session.getFichothequeEditor().getThesaurusEditor(this.thesaurus).getThesaurusMetadataEditor();
            done = this.update(thesaurusMetadataEditor);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        if (done) {
            this.setDone("_ done.thesaurus.thesaurusphrases", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        this.checkPhrasesParameters();
    }
}

