/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusCreation";
    public static final String COMMANDKEY = "_ THS-01";
    public static final String NEWTHESAURUS_PARAMNAME = "newthesaurus";
    public static final String THESAURUSTYPE_PARAMNAME = "thesaurustype";
    private SubsetKey newThesaurusKey;
    private short thesaurusType;

    public ThesaurusCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Thesaurus thesaurus;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            try {
                ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().createThesaurus(this.newThesaurusKey, this.thesaurusType);
                if (this.thesaurusType != 3) {
                    thesaurusEditor.getThesaurusMetadataEditor().setAuthorizedLangs(this.bdfServer.getLangConfiguration().getWorkingLangs());
                }
                thesaurus = thesaurusEditor.getThesaurus();
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.setDone("_ done.thesaurus.thesauruscreation", this.newThesaurusKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String newThesaurusName = this.getMandatory(NEWTHESAURUS_PARAMNAME);
        newThesaurusName = newThesaurusName.trim();
        if (newThesaurusName.length() == 0) {
            throw BdfErrors.error("_ error.empty.thesaurusname", newThesaurusName);
        }
        try {
            this.newThesaurusKey = SubsetKey.parse((short)2, newThesaurusName);
            if (this.fichotheque.containsSubset(this.newThesaurusKey)) {
                throw BdfErrors.error("_ error.existing.thesaurus", this.newThesaurusKey.getKeyString());
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.thesaurusname", newThesaurusName);
        }
        String thesaurusTypeString = this.getMandatory(THESAURUSTYPE_PARAMNAME);
        try {
            this.thesaurusType = ThesaurusUtils.thesaurusTypeToShort(thesaurusTypeString);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(THESAURUSTYPE_PARAMNAME, thesaurusTypeString);
        }
    }
}

