/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class RedacteurChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurChange";
    public static final String COMMANDKEY = "_ USR-01";
    public static final String SURNAME_PARAMNAME = "surname";
    public static final String NONLATIN_PARAMNAME = "nonlatin";
    public static final String FORENAME_PARAMNAME = "forename";
    public static final String EMAIL_PARAMNAME = "email";
    public static final String SURNAMEFIRST_PARAMNAME = "surnamefirst";
    private PersonCore person;
    private EmailCore email;
    private Redacteur redacteur;

    public RedacteurChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            SphereEditor sphereEditor = session.getFichothequeEditor().getSphereEditor(this.redacteur.getSubsetKey());
            sphereEditor.setPerson(this.redacteur, this.person);
            sphereEditor.setEmail(this.redacteur, this.email);
        }
        this.setDone("_ done.sphere.redacteurchange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.checkSphereSupervisor(this.redacteur.getSubsetName());
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, this.redacteur);
        if (!isSame || !this.bdfServer.getPolicyManager().getUserAllow().isDataChangeAllowed()) {
            this.checkSubsetAdmin(this.redacteur.getSphere());
        }
        this.initEmail();
        this.initPerson();
    }

    private void initEmail() throws ErrorMessageException {
        String emailString = StringUtils.cleanString(this.requestHandler.getTrimedParameter(EMAIL_PARAMNAME));
        if (emailString.isEmpty()) {
            this.email = null;
        } else {
            try {
                this.email = EmailCoreUtils.parse(emailString);
            }
            catch (ParseException pe) {
                throw BdfErrors.error("_ error.wrong.email", emailString);
            }
        }
    }

    private void initPerson() throws ErrorMessageException {
        String surname = StringUtils.cleanString(this.getMandatory(SURNAME_PARAMNAME));
        String forename = StringUtils.cleanString(this.requestHandler.getTrimedParameter(FORENAME_PARAMNAME));
        String nonlatin = StringUtils.cleanString(this.requestHandler.getTrimedParameter(NONLATIN_PARAMNAME));
        boolean surnameFirst = this.requestHandler.isTrue(SURNAMEFIRST_PARAMNAME);
        this.person = PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
    }
}

