/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.tableparser.TableParser;

public abstract class AbstractImportParseCommand
extends AbstractBdfCommand {
    public static final String FIELDSORIGIN_PARAMNAME = "fieldsorigin";
    public static final String INPUT_FIELDSORIGIN_PARAMVALUE = "input";
    public static final String FIRSTLINE_FIELDSORIGIN_PARAMVALUE = "firstline";
    public static final String FIELDS_PARAMNAME = "fields";
    public static final String CONTENT_PARAMNAME = "content";
    public static final String FILE_PARAMNAME = "file";
    public static final String CHARSET_PARAMNAME = "charset";
    protected String[] fieldsArray;
    protected String[][] lines;

    public AbstractImportParseCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    protected void checkLines() throws ErrorMessageException {
        String fieldsOrigin = this.getMandatory(FIELDSORIGIN_PARAMNAME);
        boolean inputFieldsOrigin = fieldsOrigin.equals(INPUT_FIELDSORIGIN_PARAMVALUE);
        TableParser.Parameters tableParserParameters = this.requestHandler.getTableParserParameters();
        String fieldsValue = this.requestHandler.getParameter(FIELDS_PARAMNAME, inputFieldsOrigin);
        String charset = this.requestHandler.getTrimedParameter(CHARSET_PARAMNAME);
        this.requestHandler.disableStore();
        String contentString = this.getContent(charset);
        this.lines = TableParser.parse(contentString, tableParserParameters);
        if (inputFieldsOrigin) {
            this.fieldsArray = StringUtils.getTechnicalTokens(fieldsValue, true);
        } else {
            int length = this.lines.length;
            if (length == 0) {
                this.fieldsArray = new String[0];
            } else {
                this.fieldsArray = this.lines[0];
                String[][] tempo = new String[length - 1][];
                System.arraycopy(this.lines, 1, tempo, 0, length - 1);
                this.lines = tempo;
            }
        }
    }

    private String getContent(String charset) throws ErrorMessageException {
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            return this.getMandatory(CONTENT_PARAMNAME);
        }
        try {
            String content = this.getContent(fileValue, charset);
            fileValue.free();
            return content;
        }
        catch (ErrorMessageException eme) {
            fileValue.free();
            throw eme;
        }
    }

    private String getContent(FileValue fileValue, String charset) throws ErrorMessageException {
        String string;
        block13: {
            if (!charset.isEmpty()) {
                boolean supported;
                try {
                    supported = Charset.isSupported(charset);
                }
                catch (IllegalCharsetNameException icne) {
                    supported = false;
                }
                if (!supported) {
                    throw BdfErrors.wrongParameterValue(CHARSET_PARAMNAME, charset);
                }
            } else {
                charset = "UTF-8";
            }
            InputStream is = fileValue.getInputStream();
            try {
                string = IOUtils.toString(is, charset);
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw BdfErrors.ioException(ioe);
                }
            }
            is.close();
        }
        return string;
    }
}

