/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TemplateContentChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateContentChange";
    public static final String COMMANDKEY = "_ EXP-35";
    public static final String CONTENT_PARAMNAME = "content";
    private TemplateKey templateKey;
    private String contentPath;
    private String content;

    public TemplateContentChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        TemplateDescription templateDescription;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        try (InputStream is = IOUtils.toInputStream(this.content, "UTF-8");){
            templateDescription = this.bdfServer.getTransformationManager().putTemplateContent(this.templateKey, this.contentPath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.templatecontent_io", ioe.getMessage());
        }
        if (templateDescription != null) {
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templatecontentchange", this.templateKey.getKeyString(), this.contentPath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        this.templateKey = templateDescription.getTemplateKey();
        this.contentPath = this.requestHandler.getMandatoryPath();
        this.content = this.getMandatory(CONTENT_PARAMNAME);
    }
}

