/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDescription;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TableExportContentRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportContentRemove";
    public static final String COMMANDKEY = "_ EXP-16";
    private TableExportContentDescription tableExportContentDescription;

    public TableExportContentRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        String contentPath;
        String tableExportName;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        TableExportDescription newTableExportDescription = tableExportManager.removeTableExportContent(tableExportName = this.tableExportContentDescription.getTableExportName(), contentPath = this.tableExportContentDescription.getPath(), editOrigin);
        if (newTableExportDescription != null) {
            this.putResultObject("obj.tableexportdescription", newTableExportDescription);
            this.setDone("_ done.exportation.tableexportcontentremove", tableExportName, contentPath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        if (!tableExportDescription.isEditable()) {
            throw BdfErrors.unsupportedNotEditableParameterValue("tableexport", tableExportDescription.getName());
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        this.tableExportContentDescription = this.requestHandler.getMandatoryTableExportContentDescription(tableExportDescription);
    }
}

