/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.configuration.LangConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class LangConfigCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "LangConfig";
    public static final String COMMANDKEY = "_ CNF-03";
    public static final String WORKINGLANG_PARAMNAME = "workinglang";
    public static final String SUPPLEMENTARYLANG_PARAMNAME = "supplementarylang";
    public static final String ALLLANG_PARAMNAME = "alllang";
    public static final String WITHNONLATIN_PARAMNAME = "withnonlatin";
    public static final String WITHOUTSURNAMEFIRST = "withoutsurnamefirst";
    private Lang[] workingArray;
    private Lang[] supplementaryArray;
    private boolean allLanguage;
    private boolean withNonlatin;
    private boolean withoutSurnameFirst;

    public LangConfigCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        LangConfigurationBuilder langConfigurationBuilder = LangConfigurationBuilder.init().setWithNonlatin(this.withNonlatin).setWithoutSurnameFirst(this.withoutSurnameFirst).setAllLanguages(this.allLanguage);
        for (Lang lang : this.workingArray) {
            langConfigurationBuilder.addWorkingLang(lang);
        }
        if (!this.allLanguage) {
            for (Lang lang : this.supplementaryArray) {
                langConfigurationBuilder.addSupplementaryLang(lang);
            }
        }
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            session.getBdfServerEditor().setLangConfiguration(langConfigurationBuilder.toLangConfiguration());
        }
        this.setDone("_ done.configuration.langconfig", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String workingLangParam = this.getMandatory(WORKINGLANG_PARAMNAME);
        this.workingArray = LangsUtils.toCleanLangArray(workingLangParam);
        if (this.workingArray.length == 0) {
            throw BdfErrors.error("_ error.empty.workinglang");
        }
        this.allLanguage = this.requestHandler.isTrue(ALLLANG_PARAMNAME);
        if (!this.allLanguage) {
            String supplementaryLangParam = this.getMandatory(SUPPLEMENTARYLANG_PARAMNAME);
            this.supplementaryArray = LangsUtils.toCleanLangArray(supplementaryLangParam);
        }
        this.withNonlatin = this.requestHandler.isTrue(WITHNONLATIN_PARAMNAME);
        this.withoutSurnameFirst = this.requestHandler.isTrue(WITHOUTSURNAMEFIRST);
    }
}

