/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class AlbumRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AlbumRemove";
    public static final String COMMANDKEY = "_ ALB-10";
    private Album album;

    public AlbumRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SubsetKey albumKey = this.album.getSubsetKey();
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            try {
                session.getFichothequeEditor().removeAlbum(this.album);
            }
            catch (NoRemoveableSubsetException nrse) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.subsetkey", albumKey);
        this.setDone("_ done.album.albumremove", albumKey.getSubsetName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.album = this.requestHandler.getMandatoryAlbum();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.album.isRemoveable()) {
            throw BdfErrors.error("_ error.notremoveable.album");
        }
    }
}

