/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class RoleCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RoleCreation";
    public static final String COMMANDKEY = "_ ROL-01";
    public static final String NEWROLE_PARAMNAME = "newrole";
    private String newRoleName;

    public RoleCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        Role role;
        try (EditSession session = this.startEditSession("administration", COMMANDNAME);){
            try {
                role = session.getBdfServerEditor().getRoleEditor().createRole(this.newRoleName);
            }
            catch (ParseException | ExistingIdException e) {
                throw new ShouldNotOccurException("Test done before");
            }
        }
        this.setDone("_ done.administration.rolecreation", this.newRoleName);
        this.putResultObject("obj.role", role);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newRoleName = this.getMandatory(NEWROLE_PARAMNAME);
        this.newRoleName = this.newRoleName.trim();
        if (this.newRoleName.length() == 0) {
            throw BdfErrors.error("_ error.empty.rolename", this.newRoleName);
        }
        if (!StringUtils.isTechnicalName(this.newRoleName, true)) {
            throw BdfErrors.error("_ error.wrong.rolename", this.newRoleName);
        }
        Role role = this.bdfServer.getPermissionManager().getRole(this.newRoleName);
        if (role != null) {
            throw BdfErrors.error("_ error.existing.role", this.newRoleName);
        }
    }
}

