/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.interaction;

public final class Domain {
    private final String complete;
    private final String firstPart;
    private final String secondPart;

    public Domain(String firstPart, String secondPart) {
        if (firstPart == null) {
            throw new IllegalArgumentException("firstPart is null");
        }
        if (secondPart == null) {
            throw new IllegalArgumentException("secondPart is null");
        }
        this.firstPart = firstPart;
        this.secondPart = secondPart;
        this.complete = Domain.getCompleteDomain(firstPart, secondPart);
    }

    public String getFirstPart() {
        return this.firstPart;
    }

    public String getSecondPart() {
        return this.secondPart;
    }

    public String toString() {
        return this.complete;
    }

    public int hashCode() {
        return this.complete.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Domain otherDomain = (Domain)other;
        return otherDomain.complete.equals(this.complete);
    }

    public static String getCompleteDomain(String firstPart, String secondPart) {
        if (secondPart.isEmpty()) {
            return firstPart;
        }
        return firstPart + "-" + secondPart;
    }

    public static Domain parse(String complete) {
        int idx = complete.indexOf(45);
        if (idx == -1) {
            return new Domain(complete, "");
        }
        return new Domain(complete.substring(0, idx), complete.substring(idx + 1));
    }
}

