/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.primitives.RangeDateFilter;

public class AnalytiqueDetailsBuilder {
    private final List<AnalytiqueDetail> analytiqueDetailList = new ArrayList<AnalytiqueDetail>();
    private final RangeDateFilter dateFilter;
    private final AnalytiqueParameters analytiqueParameters;
    private final Currencies customCurrencies;
    private final AnalytiqueItem analytiqueItem;

    public AnalytiqueDetailsBuilder(AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Currencies customCurrencies) {
        this.analytiqueParameters = analytiqueParameters;
        this.dateFilter = dateFilter;
        this.customCurrencies = customCurrencies;
        this.analytiqueItem = null;
    }

    public AnalytiqueDetailsBuilder(AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Currencies customCurrencies, AnalytiqueItem analytiqueItem) {
        this.analytiqueParameters = analytiqueParameters;
        this.dateFilter = dateFilter;
        this.customCurrencies = customCurrencies;
        this.analytiqueItem = analytiqueItem;
    }

    public AnalytiqueDetailsBuilder addAnalytiqueDetail(AnalytiqueDetail analytiqueDetail) {
        this.analytiqueDetailList.add(analytiqueDetail);
        return this;
    }

    public AnalytiqueDetails toAnalytiqueDetails() {
        List<AnalytiqueDetail> finalAnalytiqueDetailList = AnalytiqueUtils.wrap(this.analytiqueDetailList.toArray(new AnalytiqueDetail[this.analytiqueDetailList.size()]));
        if (this.analytiqueItem != null) {
            return new InternalItemAnalytiqueDetails(this.analytiqueItem, finalAnalytiqueDetailList, this.dateFilter, this.customCurrencies, this.analytiqueParameters);
        }
        return new InternalAnalytiqueDetails(finalAnalytiqueDetailList, this.dateFilter, this.customCurrencies, this.analytiqueParameters);
    }

    public static AnalytiqueDetailsBuilder init(AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Currencies customCurrencies) {
        return new AnalytiqueDetailsBuilder(analytiqueParameters, dateFilter, customCurrencies);
    }

    public static AnalytiqueDetailsBuilder init(AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Currencies customCurrencies, AnalytiqueItem analytiqueItem) {
        return new AnalytiqueDetailsBuilder(analytiqueParameters, dateFilter, customCurrencies, analytiqueItem);
    }

    private static class InternalItemAnalytiqueDetails
    implements ItemAnalytiqueDetails {
        private final AnalytiqueItem analytiqueItem;
        private final List<AnalytiqueDetail> analytiqueDetailList;
        private final RangeDateFilter dateFilter;
        private final AnalytiqueParameters analytiqueParameters;
        private final Currencies customCurrencies;

        private InternalItemAnalytiqueDetails(AnalytiqueItem analytiqueItem, List<AnalytiqueDetail> analytiqueDetailList, RangeDateFilter dateFilter, Currencies customCurrencies, AnalytiqueParameters analytiqueParameters) {
            this.analytiqueItem = analytiqueItem;
            this.analytiqueDetailList = analytiqueDetailList;
            this.dateFilter = dateFilter;
            this.customCurrencies = customCurrencies;
            this.analytiqueParameters = analytiqueParameters;
        }

        @Override
        public AnalytiqueSubset getAnalytiqueSubset() {
            return this.analytiqueParameters.getAnalytiqueSubset();
        }

        @Override
        public Currencies getCustomCurrencies() {
            return this.customCurrencies;
        }

        @Override
        public RangeDateFilter getRangeDateFilter() {
            return this.dateFilter;
        }

        @Override
        public AnalytiqueItem getAnalytiqueItem() {
            return this.analytiqueItem;
        }

        @Override
        public List<AnalytiqueDetail> getAnalytiqueDetailList() {
            return this.analytiqueDetailList;
        }

        @Override
        public AnalytiqueParameters getAnalytiqueParameters() {
            return this.analytiqueParameters;
        }
    }

    private static class InternalAnalytiqueDetails
    implements AnalytiqueDetails {
        private final List<AnalytiqueDetail> analytiqueDetailList;
        private final RangeDateFilter dateFilter;
        private final AnalytiqueParameters analytiqueParameters;
        private final Currencies customCurrencies;

        private InternalAnalytiqueDetails(List<AnalytiqueDetail> analytiqueDetailList, RangeDateFilter dateFilter, Currencies customCurrencies, AnalytiqueParameters analytiqueParameters) {
            this.analytiqueDetailList = analytiqueDetailList;
            this.dateFilter = dateFilter;
            this.customCurrencies = customCurrencies;
            this.analytiqueParameters = analytiqueParameters;
        }

        @Override
        public AnalytiqueSubset getAnalytiqueSubset() {
            return this.analytiqueParameters.getAnalytiqueSubset();
        }

        @Override
        public Currencies getCustomCurrencies() {
            return this.customCurrencies;
        }

        @Override
        public RangeDateFilter getRangeDateFilter() {
            return this.dateFilter;
        }

        @Override
        public List<AnalytiqueDetail> getAnalytiqueDetailList() {
            return this.analytiqueDetailList;
        }

        @Override
        public AnalytiqueParameters getAnalytiqueParameters() {
            return this.analytiqueParameters;
        }
    }
}

