/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.json;

import fr.exemole.bdfext.scarabe.api.exportation.ScarabeColDef;
import fr.exemole.bdfext.scarabe.tools.exportation.Columns;
import java.io.IOException;
import net.fichotheque.exportation.table.ColDef;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.Labels;

public class ColumnsJsonProperty
implements JsonProperty {
    private final Columns columns;
    private final MessageLocalisation messageLocalisation;
    private final Lang lang;

    public ColumnsJsonProperty(Columns columns, MessageLocalisation messageLocalisation, Lang lang) {
        this.columns = columns;
        this.messageLocalisation = messageLocalisation;
        this.lang = lang;
    }

    public String getName() {
        return "columns";
    }

    public void writeValue(JSONWriter jw) throws IOException {
        jw.array();
        for (ColDef colDef : this.columns.getColDefList()) {
            jw.object();
            this.writeColumnProperties(jw, colDef);
            jw.endObject();
        }
        jw.endArray();
    }

    private void writeColumnProperties(JSONWriter jw, ColDef colDef) throws IOException {
        jw.key("name").value((Object)colDef.getColName());
        jw.key("title").value((Object)this.getTitle(colDef));
        if (colDef instanceof ScarabeColDef) {
            String colName = colDef.getColName();
            String value = colName.equals("scarabe_numeropiece") ? "piece" : colName.substring("scarabe_".length());
            jw.key("scarabe").value((Object)value);
        }
    }

    private String getTitle(ColDef colDef) {
        Labels labels = colDef.getCustomLabels();
        if (labels != null) {
            return labels.seekLabelString(this.lang, colDef.getColName());
        }
        String messageKey = (String)colDef.getParameterValue("messageKey");
        if (messageKey != null) {
            return this.messageLocalisation.toString(messageKey);
        }
        return colDef.getColName();
    }
}

