/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.io.File;
import java.text.ParseException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.DefaultTextBoxManager;
import net.desmodo.atlas.boxes.TextBoxManager;
import net.desmodo.atlas.conf.ConfEvent;
import net.desmodo.atlas.conf.ConfListener;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.event.AtlasMetadataEvent;
import net.desmodo.atlas.event.AtlasMetadataListener;
import net.desmodo.atlas.event.AttributeEvent;
import net.desmodo.atlas.event.AttributeListener;
import net.desmodo.atlas.event.CompoundAtlasEvent;
import net.desmodo.atlas.event.CompoundAtlasEventListener;
import net.desmodo.atlas.event.DescripteurEvent;
import net.desmodo.atlas.event.DescripteursListener;
import net.desmodo.atlas.event.LabelEvent;
import net.desmodo.atlas.event.LabelListener;
import net.desmodo.atlas.event.LienEvent;
import net.desmodo.atlas.event.LiensListener;
import net.desmodo.atlas.event.StructureEvent;
import net.desmodo.atlas.event.StructureListener;
import net.desmodo.atlas.session.ConfLiaisonFilter;
import net.desmodo.atlas.session.Navigation;
import net.desmodo.atlas.session.NavigationKey;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.session.SessionInitParameters;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.wrapper.AtlasWrapper;
import net.desmodo.atlas.wrapper.GroupeItemManager;
import net.desmodo.atlas.wrapper.LibelleItemManager;
import net.desmodo.atlas.wrapper.VentilationNameItem;
import net.desmodo.atlas.wrapper.VentilationNameItemManager;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.net.URLHandler;

public class Session
implements SessionConfKeys {
    private Atlas atlas;
    private AtlasEditor atlasEditor;
    private NavigationKey homeNavigationKey;
    private Navigation navigation;
    private SessionConf sessionConf;
    private AtlasWrapper atlasWrapper;
    private ConfLiaisonFilter sessionConfLiaisonFilter;
    private AtlasListener atlasListener;
    private DefaultTextBoxManager textBoxManager;
    private URLHandler urlHandler;

    public Session(SessionInitParameters sessionInitParameters) {
        SessionInitParameters.checkParameters(sessionInitParameters);
        this.atlasEditor = sessionInitParameters.getAtlasEditor();
        this.atlas = this.atlasEditor.getAtlas();
        this.atlasWrapper = sessionInitParameters.getAtlasWrapper();
        this.sessionConf = sessionInitParameters.getSessionConf();
        this.sessionConfLiaisonFilter = new ConfLiaisonFilter(this.atlas, this.sessionConf);
        this.textBoxManager = new DefaultTextBoxManager(this);
        this.initHomeNavigationKey();
        this.navigation = new Navigation(this, this.homeNavigationKey);
        this.atlasListener = new AtlasListener();
        this.urlHandler = sessionInitParameters.getURLHandler();
        new InternalSessionConfListener();
    }

    private void initHomeNavigationKey() {
        VentilationName ventilationName;
        try {
            ventilationName = VentilationName.parse(this.sessionConf.getString("home.ventilationname"), this.atlas);
            VentilationNameItem ventilationNameItem = this.getVentilationNameItemManager().getVentilationNameItem(ventilationName);
            if (ventilationNameItem == null) {
                ventilationName = VentilationName.VENTILATION_NATURELLE;
            }
        }
        catch (ParseException pe) {
            ventilationName = VentilationName.VENTILATION_NATURELLE;
        }
        String ventilationRootString = this.sessionConf.getString("home.ventilationroot");
        Term term = SessionUtils.getHomeTerm(ventilationRootString, this.atlas);
        this.homeNavigationKey = new NavigationKey(term, ventilationName);
    }

    public String getIddescPrefix() {
        return this.sessionConf.getString("atlas.iddesc.prefix");
    }

    public Atlas getAtlas() {
        return this.atlas;
    }

    public AtlasEditor getAtlasEditor() {
        return this.atlasEditor;
    }

    public SessionConf getSessionConf() {
        return this.sessionConf;
    }

    public URLHandler getURLHandler() {
        return this.urlHandler;
    }

    public void setHomeNavigationKey(NavigationKey navigationKey) {
        if (!navigationKey.equals(this.homeNavigationKey)) {
            this.homeNavigationKey = navigationKey;
            this.sessionConf.queueEvents();
            this.sessionConf.setString("home.ventilationname", navigationKey.getVentilationName().toUriString());
            this.sessionConf.setString("home.ventilationroot", AtlasURI.toURIString(navigationKey.getVentilationRoot()));
            this.sessionConf.flushEvents();
        }
    }

    public NavigationKey getHomeNavigationKey() {
        return this.homeNavigationKey;
    }

    public LibelleItemManager getLibelleItemManager() {
        return this.atlasWrapper.getLibelleItemManager();
    }

    public GroupeItemManager getGroupeItemManager() {
        return this.atlasWrapper.getGroupeItemManager();
    }

    public VentilationNameItemManager getVentilationNameItemManager() {
        return this.atlasWrapper.getVentilationNameItemManager();
    }

    public VentilationFactory getVentilationFactory() {
        return this.atlasWrapper.getVentilationFactory();
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public TextBoxManager getTextBoxManager() {
        return this.textBoxManager;
    }

    public LiaisonFilter getLiaisonFilter() {
        return this.sessionConfLiaisonFilter;
    }

    public void setSaved(File f) {
        this.sessionConf.queueEvents();
        this.sessionConf.setFile("trans.file", f);
        this.sessionConf.setBoolean("trans.unsaved.conf", false);
        this.sessionConf.setBoolean("trans.unsaved.atlas", false);
        this.sessionConf.flushEvents();
    }

    private class AtlasListener
    implements AttributeListener,
    LabelListener,
    DescripteursListener,
    StructureListener,
    CompoundAtlasEventListener,
    LiensListener,
    AtlasMetadataListener {
        private boolean compoundAtlasEventProcessed = false;
        private boolean modifDone = true;
        private int navigationChangeMask = 0;

        public AtlasListener() {
            Session.this.atlas.addAttributeListener(this);
            Session.this.atlas.addLibelleListener(this);
            Session.this.atlas.addCompoundAtlasEventListener(this);
            Session.this.atlas.getStructure().addStructureListener(this);
            Session.this.atlas.getDescripteurs().addDescripteursListener(this);
            Session.this.atlas.getLiens().addLiensListener(this);
            Session.this.atlas.getAtlasMetadata().addAtlasMetadataListener(this);
        }

        @Override
        public void attributeRemoved(AttributeEvent attributeEvent) {
            AttributeKey attributeKey = attributeEvent.getAttributeKey();
            if (attributeKey.equals((Object)AtlasAttributes.COLOR_KEY)) {
                Session.this.textBoxManager.clearBuffer();
                this.appendEvent(64);
            } else {
                this.appendEvent(512);
            }
        }

        @Override
        public void attributeChanged(AttributeEvent attributeEvent) {
            AttributeKey attributeKey = attributeEvent.getAttributeKey();
            if (attributeKey.equals((Object)AtlasAttributes.COLOR_KEY)) {
                Session.this.textBoxManager.clearBuffer();
                this.appendEvent(64);
            } else {
                this.appendEvent(512);
            }
        }

        @Override
        public void contexteCreated(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void grilleCreated(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void grilleRemoved(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void familleChanged(DescripteurEvent descripteurEvent) {
            Session.this.textBoxManager.clearBuffer(descripteurEvent.getDescripteur());
            this.appendEvent(64);
        }

        @Override
        public void labelRemoved(LabelEvent labelEvent) {
            Object labelHolder = labelEvent.getLabelHolder();
            if (labelHolder instanceof Term) {
                Session.this.textBoxManager.clearBuffer((Term)labelHolder);
                this.appendEvent(128);
            }
        }

        @Override
        public void labelChanged(LabelEvent labelEvent) {
            Object labelHolder = labelEvent.getLabelHolder();
            if (labelHolder instanceof Term) {
                Session.this.textBoxManager.clearBuffer((Term)labelHolder);
                this.appendEvent(128);
            }
        }

        @Override
        public void descripteurCreated(DescripteurEvent descripteurEvent) {
            this.appendEvent(0);
        }

        @Override
        public void descripteurRemoved(DescripteurEvent descripteurEvent) {
            Descripteur descripteur = descripteurEvent.getDescripteur();
            Term trm = Session.this.homeNavigationKey.getVentilationRoot();
            if (trm != null && trm.equals(descripteur)) {
                Session.this.setHomeNavigationKey(new NavigationKey(null, Session.this.homeNavigationKey.getVentilationName()));
            }
            Session.this.navigation.removeRoot(descripteur);
            this.appendEvent(0);
        }

        @Override
        public void activeChanged(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void parentChanged(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void contexteRemoved(StructureEvent structureEvent) {
            Contexte contexte = structureEvent.getContexte();
            Session.this.navigation.removeRoot(contexte);
            this.appendEvent(4);
        }

        @Override
        public void descripteurAdded(LienEvent lienEvent) {
            this.appendEvent(4);
        }

        @Override
        public void descripteurRemoved(LienEvent lienEvent) {
            this.appendEvent(4);
        }

        @Override
        public void indexChanged(LienEvent lienEvent) {
            this.appendEvent(4);
        }

        @Override
        public void lienAdded(LienEvent lienEvent) {
            this.appendEvent(4);
        }

        @Override
        public void lienRemoved(LienEvent lienEvent) {
            this.appendEvent(4);
        }

        @Override
        public void endCompoundAtlasEvent(CompoundAtlasEvent compoundAtlasEvent) {
            this.compoundAtlasEventProcessed = false;
            if (this.modifDone) {
                this.appendEvent(this.navigationChangeMask);
            }
            this.modifDone = false;
            this.navigationChangeMask = 0;
        }

        @Override
        public void startCompoundAtlasEvent(CompoundAtlasEvent compoundAtlasEvent) {
            this.compoundAtlasEventProcessed = true;
        }

        @Override
        public void externalEventInserted(CompoundAtlasEvent compoundAtlasEvent) {
            this.modifDone = true;
        }

        @Override
        public void childIndexChanged(StructureEvent structureEvent) {
            this.appendEvent(4);
        }

        @Override
        public void workingLangIntegerListChanged(AtlasMetadataEvent atlasMetadataEvent) {
            this.appendEvent(0);
        }

        private void appendEvent(int changeMask) {
            if (!this.compoundAtlasEventProcessed) {
                Session.this.sessionConf.setBoolean("trans.unsaved.atlas", true);
                Session.this.navigation.updateVentilation(changeMask, null);
            } else {
                this.modifDone = true;
                this.navigationChangeMask |= changeMask;
            }
        }
    }

    private class InternalSessionConfListener
    implements ConfListener {
        private boolean processEvent = false;

        InternalSessionConfListener() {
            Session.this.sessionConf.addConfListener(this);
        }

        @Override
        public void confChanged(ConfEvent confEvent) {
            if (!this.processEvent) {
                this.processEvent = true;
                boolean isLiaisonFilterConcerned = false;
                boolean isSkinConcerned = false;
                for (int i = 0; i < confEvent.getParamNameCount(); ++i) {
                    String paramName = confEvent.getParamName(i);
                    if (!Session.this.sessionConf.isTransient(paramName)) {
                        Session.this.sessionConf.setBoolean("trans.unsaved.conf", true);
                    }
                    if (SessionConf.concernLiaisonFilter(paramName)) {
                        isLiaisonFilterConcerned = true;
                    }
                    if (!SessionConf.concernSkin(paramName)) continue;
                    isSkinConcerned = true;
                }
                if (isSkinConcerned) {
                    Session.this.textBoxManager.clearBuffer();
                }
                if (isLiaisonFilterConcerned) {
                    Session.this.sessionConfLiaisonFilter.reinit();
                }
                Session.this.navigation.confChanged(confEvent);
                this.processEvent = false;
            }
        }
    }
}

