/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.producers;

import java.awt.Color;
import java.io.IOException;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Sommet;
import net.desmodo.atlas.json.api.FieldFilter;
import net.desmodo.atlas.json.producers.AbstractJsonProducer;
import net.desmodo.atlas.json.producers.AtlasJsonUtils;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;
import net.mapeadores.util.awt.ColorUtils;
import net.mapeadores.util.json.JSONWriter;

public class VentilationJsonProducer
extends AbstractJsonProducer {
    private final Ventilation ventilation;
    private final FaisceauAngulaire faisceau;
    private final FieldFilter rootFieldFilter;
    private final FieldFilter secteurFieldFilter;
    private final FieldFilter liaisonFieldFilter;

    public VentilationJsonProducer(Ventilation ventilation, FaisceauAngulaire faisceau, FieldFilter rootFieldFilter, FieldFilter secteurFieldFilter, FieldFilter liaisonFieldFilter) {
        this.ventilation = ventilation;
        this.faisceau = faisceau;
        this.rootFieldFilter = rootFieldFilter;
        this.secteurFieldFilter = secteurFieldFilter;
        this.liaisonFieldFilter = liaisonFieldFilter;
    }

    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jsonWriter = new JSONWriter(appendable);
        jsonWriter.object();
        jsonWriter.key("ventilation");
        jsonWriter.object();
        jsonWriter.key("name");
        jsonWriter.value((Object)this.ventilation.getVentilationName().toUriString());
        Term root = this.ventilation.getRoot();
        if (root != null) {
            jsonWriter.key("root");
            AtlasJsonUtils.termObject(jsonWriter, root, this.rootFieldFilter);
        }
        this.writeColorStyle(jsonWriter, this.ventilation.getColorStyle());
        SecteurList secteurList = this.ventilation.getFirstLevelSecteurList();
        int secteurCount = secteurList.getSecteurCount();
        Counter counter = new Counter();
        if (secteurCount > 0) {
            jsonWriter.key("secteurArray");
            jsonWriter.array();
            for (int i = 0; i < secteurCount; ++i) {
                Secteur secteur = secteurList.getSecteur(i);
                Counter secteurCounter = this.writeSecteur(jsonWriter, secteur);
                counter.add(secteurCounter);
            }
            jsonWriter.endArray();
        }
        counter.write(jsonWriter);
        jsonWriter.endObject();
        if (this.faisceau != null) {
            this.writeFaisceauAngulaire(jsonWriter);
        }
        this.writeWarnings(jsonWriter);
        jsonWriter.endObject();
    }

    private void writeFaisceauAngulaire(JSONWriter jsonWriter) throws IOException {
        jsonWriter.key("faisceau");
        jsonWriter.object();
        jsonWriter.key("xyratio");
        jsonWriter.value(this.faisceau.getXYRatio());
        jsonWriter.key("trigosecteurarc");
        jsonWriter.value(this.faisceau.getCartesianTrigoSecteurArc());
        int secteurAngulaireCount = this.faisceau.getSecteurAngulaireCount();
        if (secteurAngulaireCount > 0) {
            jsonWriter.key("secteurangulaireArray");
            jsonWriter.array();
            for (int i = 0; i < secteurAngulaireCount; ++i) {
                SecteurAngulaire secteurAngulaire = this.faisceau.getSecteurAngulaire(i);
                jsonWriter.object();
                jsonWriter.key("ventilationcode");
                jsonWriter.value((long)secteurAngulaire.getSecteur().getVentilationCode());
                jsonWriter.key("index");
                jsonWriter.value((long)secteurAngulaire.getIndex());
                jsonWriter.key("arctype");
                jsonWriter.value((long)secteurAngulaire.getArcType());
                jsonWriter.key("arccolor");
                jsonWriter.value((Object)ColorUtils.toHexFormat((Color)secteurAngulaire.getArcColorStyle().getColor()));
                jsonWriter.key("segmentcolor");
                jsonWriter.value((Object)ColorUtils.toHexFormat((Color)secteurAngulaire.getSeparatorWithPreviousColorStyle().getColor()));
                Sommet sommet = secteurAngulaire.getFirstSommet();
                jsonWriter.key("trigoangle");
                jsonWriter.value(sommet.getCartesianTrigoAngle());
                jsonWriter.key("ellipseangle");
                jsonWriter.value(sommet.getCartesianEllipseAngle());
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    private Counter writeSecteur(JSONWriter jsonWriter, Secteur secteur) throws IOException {
        SecteurList secteurList;
        int secteurCount;
        Counter counter = new Counter();
        jsonWriter.object();
        Term term = secteur.getSecteurTerm();
        jsonWriter.key("terme");
        AtlasJsonUtils.termObject(jsonWriter, term, this.secteurFieldFilter);
        this.writeColorStyle(jsonWriter, secteur.getColorStyle());
        boolean active = secteur.isActive();
        jsonWriter.key("active");
        jsonWriter.value(active);
        jsonWriter.key("profondeur");
        jsonWriter.value((long)secteur.getProfondeur());
        jsonWriter.key("ventilationcode");
        jsonWriter.value((long)secteur.getVentilationCode());
        LiaisonList liaisonList = secteur.getLiaisonList();
        int liaisonCount = liaisonList.getLiaisonCount();
        if (liaisonCount > 0) {
            counter.addLiaison(liaisonCount);
            jsonWriter.key("liaisonArray");
            jsonWriter.array();
            for (int i = 0; i < liaisonCount; ++i) {
                Liaison liaison = liaisonList.getLiaison(i);
                this.writeLiaison(jsonWriter, liaison);
            }
            jsonWriter.endArray();
        }
        if ((secteurCount = (secteurList = secteur.getChildren()).getSecteurCount()) > 0) {
            jsonWriter.key("secteurArray");
            jsonWriter.array();
            for (int i = 0; i < secteurCount; ++i) {
                Secteur child = secteurList.getSecteur(i);
                Counter childCounter = this.writeSecteur(jsonWriter, child);
                counter.add(childCounter);
            }
            jsonWriter.endArray();
        }
        counter.write(jsonWriter);
        if (active) {
            counter.addActiveSecteur(1);
            if (liaisonCount > 0) {
                counter.addUsedSecteur(1);
            }
        }
        jsonWriter.endObject();
        return counter;
    }

    private void writeLiaison(JSONWriter jsonWriter, Liaison liaison) throws IOException {
        jsonWriter.object();
        jsonWriter.key("terme");
        AtlasJsonUtils.termObject(jsonWriter, liaison.getTerm(), this.liaisonFieldFilter);
        jsonWriter.key("position");
        jsonWriter.value((long)liaison.getPosition());
        jsonWriter.endObject();
    }

    private void writeColorStyle(JSONWriter jsonWriter, ColorStyle colorStyle) throws IOException {
        jsonWriter.key("color");
        jsonWriter.value((Object)ColorUtils.toHexFormat((Color)colorStyle.getColor()));
    }

    private static class Counter {
        private int liaisonCount;
        private int activeSecteurCount;
        private int usedSecteurCount;

        private Counter() {
        }

        private void add(Counter counter) {
            this.activeSecteurCount += counter.activeSecteurCount;
            this.usedSecteurCount += counter.usedSecteurCount;
            this.liaisonCount += counter.liaisonCount;
        }

        private void addActiveSecteur(int n) {
            this.activeSecteurCount += n;
        }

        private void addUsedSecteur(int n) {
            this.usedSecteurCount += n;
        }

        private void addLiaison(int n) {
            this.liaisonCount += n;
        }

        public int getActiveSecteurCount() {
            return this.activeSecteurCount;
        }

        public int getLiaisonCount() {
            return this.liaisonCount;
        }

        public int getUsedSecteurCount() {
            return this.usedSecteurCount;
        }

        private void write(JSONWriter jsonWriter) throws IOException {
            jsonWriter.key("liaisonCount");
            jsonWriter.value((long)this.liaisonCount);
            jsonWriter.key("activeSecteurCount");
            jsonWriter.value((long)this.activeSecteurCount);
            jsonWriter.key("usedSecteurCount");
            jsonWriter.value((long)this.usedSecteurCount);
        }
    }
}

