/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.sync.dom;

import fr.exemole.bdfext.desmography.sync.AtlasSyncBuilder;
import fr.exemole.bdfext.desmography.sync.RelationSyncBuilder;
import java.util.function.Consumer;
import net.fichotheque.tools.thesaurus.sync.ThesaurusSyncBuilder;
import net.fichotheque.tools.thesaurus.sync.dom.KeywordsDOMReader;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class AtlasSyncDOMReader {
    private final AtlasSyncBuilder atlasSyncBuilder;
    private final MessageHandler messageHandler;

    public AtlasSyncDOMReader(AtlasSyncBuilder atlasSyncBuilder, MessageHandler messageHandler) {
        this.atlasSyncBuilder = atlasSyncBuilder;
        this.messageHandler = messageHandler;
    }

    public AtlasSyncDOMReader read(Element element) {
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer());
        return this;
    }

    public static AtlasSyncDOMReader init(AtlasSyncBuilder atlasSyncBuilder, MessageHandler messageHandler) {
        return new AtlasSyncDOMReader(atlasSyncBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "keywords": {
                    KeywordsDOMReader.init((ThesaurusSyncBuilder)AtlasSyncDOMReader.this.atlasSyncBuilder.getThesaurusSyncBuilder(), (MessageHandler)AtlasSyncDOMReader.this.messageHandler).read(element);
                    break;
                }
                case "relations": {
                    DOMUtils.readChildren((Element)element, (Consumer)new RelationsConsumer());
                }
            }
        }
    }

    private class RelationConsumer
    implements Consumer<Element> {
        private final RelationSyncBuilder relationSyncBuilder;

        private RelationConsumer(RelationSyncBuilder relationSyncBuilder) {
            this.relationSyncBuilder = relationSyncBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String text = DOMUtils.readSimpleElement((Element)element);
            this.relationSyncBuilder.add(tagName, text);
        }
    }

    private class RelationsConsumer
    implements Consumer<Element> {
        private RelationsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "relation": {
                    try {
                        int id = Integer.parseInt(element.getAttribute("id"));
                        String type = element.getAttribute("type");
                        RelationSyncBuilder relationSyncBuilder = new RelationSyncBuilder(id, type);
                        DOMUtils.readChildren((Element)element, (Consumer)new RelationConsumer(relationSyncBuilder));
                        AtlasSyncDOMReader.this.atlasSyncBuilder.addRelation(relationSyncBuilder.toRelationSync());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

