/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.engines.AtlasEditionReport;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.Set;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogs;

public class EditionJsonProducer
extends AbstractJsonProducer {
    private Atlas atlas;
    private Lang lang;
    private String message;
    private SourceLogs editionLogs = null;
    private AtlasEditionReport atlasEditionReport;
    private MessageLocalisation messageLocalisation;

    public EditionJsonProducer(Atlas atlas, Lang lang, MessageLocalisation messageLocalisation) {
        this.atlas = atlas;
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
    }

    public void setEditionLogs(SourceLogs editionLogs) {
        this.editionLogs = editionLogs;
    }

    public void setReport(AtlasEditionReport atlasEditionReport) {
        this.atlasEditionReport = atlasEditionReport;
    }

    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("message").value((Object)"R\u00e9ussi !");
        if (this.editionLogs != null) {
            jw.key("logs");
            jw.array();
            for (SourceLog sourceLog : this.editionLogs) {
                jw.object();
                CommonJson.properties((JSONWriter)jw, (SourceLog)sourceLog, (MessageLocalisation)this.messageLocalisation);
                jw.endObject();
            }
            jw.endArray();
        }
        if (this.atlasEditionReport != null) {
            jw.key("report");
            jw.object();
            this.write(jw, this.atlasEditionReport);
            jw.endObject();
        }
        jw.endObject();
    }

    private void write(JSONWriter jw, AtlasEditionReport atlasEditionReport) throws IOException {
        Set<Motcle> motcleSet = atlasEditionReport.getCreationSet();
        if (!motcleSet.isEmpty()) {
            jw.key("creation");
            jw.array();
            for (Motcle motcle : motcleSet) {
                jw.object();
                TermJson.dataProperties(jw, this.atlas, motcle, this.lang);
                jw.endObject();
                jw.endArray();
            }
        }
    }
}

