/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.json;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.IndexationItem;
import fr.exemole.bdfext.desmography.json.Extract;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public final class TermJson {
    private TermJson() {
    }

    public static void properties(JSONWriter jw, Atlas atlas, Extract extract, Lang lang, boolean withIndexation) throws IOException {
        jw.key("terms");
        jw.array();
        Iterator<Motcle> it = extract.getTermIterator();
        while (it.hasNext()) {
            Motcle term = it.next();
            jw.object();
            TermJson.dataProperties(jw, atlas, term, lang);
            TermJson.familiesProperty(jw, atlas, term, extract);
            TermJson.rosetteProperty(jw, term.getAttributes());
            if (withIndexation) {
                TermJson.indexationProperty(jw, atlas, term, extract);
            }
            TermJson.customPropertiesProperty(jw, term);
            jw.endObject();
        }
        jw.endArray();
    }

    public static void dataProperties(JSONWriter jw, Atlas atlas, Motcle term, Lang lang) throws IOException {
        jw.key("name").value((Object)String.valueOf(term.getId()));
        String alias = AtlasUtils.getAlias(term);
        if (alias != null) {
            jw.key("alias").value((Object)alias);
        }
        TermJson.labelProperties(jw, atlas, term.getLabels(), lang);
        TermJson.attributesProperties(jw, term.getAttributes());
    }

    public static void labelProperties(JSONWriter jw, Atlas atlas, Labels labels, Lang lang) throws IOException {
        Label label = labels.getLangPartCheckedLabel(lang);
        String title = label != null ? label.getLabelString() : "";
        jw.key("title").value((Object)title);
        if (label != null) {
            if (labels.size() > 1) {
                jw.key("translations");
                jw.array();
                for (Label otherLabel : labels) {
                    if (otherLabel.equals(label)) continue;
                    jw.object();
                    jw.key("lang").value((Object)otherLabel.getLang().toString());
                    jw.key("text").value((Object)otherLabel.getLabelString());
                    jw.endObject();
                }
                jw.endArray();
            }
        } else if (!labels.isEmpty()) {
            jw.key("translations");
            jw.array();
            for (Label otherLabel : labels) {
                jw.object();
                jw.key("lang").value((Object)otherLabel.getLang().toString());
                jw.key("text").value((Object)otherLabel.getLabelString());
                jw.endObject();
            }
            jw.endArray();
        }
    }

    public static void attributesProperties(JSONWriter jw, Attributes attributes) throws IOException {
        jw.key("attributes");
        jw.object();
        for (Attribute attribute : attributes) {
            AttributeKey attributeKey = attribute.getAttributeKey();
            if (!TermJson.testNamespace(attributeKey.getNameSpace())) continue;
            jw.key(attributeKey.toString());
            jw.array();
            for (String value : attribute) {
                jw.value((Object)value);
            }
            jw.endArray();
        }
        jw.endObject();
    }

    public static void rosetteProperty(JSONWriter jw, Attributes attributes) throws IOException {
        Attribute rosetteDefault = attributes.getAttribute(DesmographySpace.ROSETTE_DEFAULT_KEY);
        if (rosetteDefault == null) {
            return;
        }
        String firstValue = rosetteDefault.getFirstValue();
        int idx = firstValue.indexOf(":");
        if (idx < 1) {
            return;
        }
        jw.key("rosette");
        jw.object();
        jw.key("default");
        jw.object();
        jw.key("mode").value((Object)firstValue.substring(0, idx));
        jw.key("name").value((Object)firstValue.substring(idx + 1));
        jw.endObject();
        jw.endObject();
    }

    public static void familiesProperty(JSONWriter jw, Atlas atlas, Motcle term, Extract extract) throws IOException {
        jw.key("families");
        jw.array();
        List<FicheMeta> superiorRelationList = AtlasUtils.getRelationList(atlas, term, "inferior", "family");
        for (FicheMeta relation : superiorRelationList) {
            List<Motcle> families = AtlasUtils.superiors(atlas, relation);
            for (Motcle family : families) {
                jw.value((Object)extract.addTerm(family));
            }
        }
        jw.endArray();
    }

    public static void indexationProperty(JSONWriter jw, Atlas atlas, Motcle term, Extract extract) throws IOException {
        Fichotheque fichotheque = atlas.getFichotheque();
        jw.key("indexation");
        jw.object();
        for (IndexationItem indexationItem : atlas.getIndexationItemMap().values()) {
            Croisements croisements = fichotheque.getCroisements((SubsetItem)term, indexationItem.getSubset());
            for (IncludeKey includeKey : indexationItem.getOtherSubsetInTermIncludeKeySet()) {
                Collection liaisons = CroisementUtils.filter((Croisements)croisements, (IncludeMode)includeKey);
                if (liaisons.isEmpty()) continue;
                jw.key(includeKey.getKeyString());
                jw.array();
                for (Liaison liaison : liaisons) {
                    jw.value((Object)extract.addResource(liaison.getSubsetItem()));
                }
                jw.endArray();
            }
        }
        jw.endObject();
    }

    public static void customPropertiesProperty(JSONWriter jw, Motcle term) throws IOException {
        jw.key("properties");
        jw.object();
        jw.key("idalpha").value((Object)term.getIdalpha());
        jw.endObject();
    }

    public static boolean testNamespace(String namespace) {
        switch (namespace) {
            case "dsm": 
            case "desmodojs": {
                return true;
            }
        }
        return namespace.startsWith("dsm.");
    }
}

