/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.inclusionresolvers;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.json.TermJson;
import java.util.TreeSet;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.logging.LineMessageHandler;

public class AttributesInclusionResolver
implements TableInclusionResolver {
    public static final String NAMESPACE = "desmography_attributes";

    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        Thesaurus atlasThesaurus = this.getTermThesaurus(tableInclusionDef, subset);
        return atlasThesaurus != null;
    }

    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        Thesaurus atlasThesaurus = this.getTermThesaurus(tableInclusionDef, subset);
        if (atlasThesaurus == null) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        TreeSet<AttributeKey> attributeKeySet = new TreeSet<AttributeKey>();
        for (Motcle term : atlasThesaurus.getMotcleList()) {
            for (Attribute attribute : term.getAttributes()) {
                AttributeKey attributeKey = attribute.getAttributeKey();
                if (!TermJson.testNamespace(attributeKey.getNameSpace())) continue;
                attributeKeySet.add(attributeKey);
            }
        }
        if (attributeKeySet.isEmpty()) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        int size = attributeKeySet.size();
        Col[] result = new Col[size];
        int p = 0;
        for (AttributeKey attributeKey : attributeKeySet) {
            result[p] = TableExportUtils.toCol((ColDef)TableDefUtils.toColDef((String)attributeKey.toString(), null), (SourceFormatter)new AttributeFormatter(attributeKey));
            ++p;
        }
        return result;
    }

    private Thesaurus getTermThesaurus(TableInclusionDef tableInclusionDef, Subset subset) {
        if (!tableInclusionDef.getNameSpace().equals(NAMESPACE)) {
            return null;
        }
        if (!(subset instanceof Thesaurus)) {
            return null;
        }
        Thesaurus thesaurus = (Thesaurus)subset;
        if (!DesmographyUtils.isAtlasThesaurus(thesaurus)) {
            return null;
        }
        return thesaurus;
    }

    private static class AttributeFormatter
    implements SourceFormatter {
        private final AttributeKey attributeKey;

        private AttributeFormatter(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
        }

        public String formatSource(FormatSource formatSource) {
            Attribute attribute = formatSource.getSubsetItemPointeur().getCurrentSubsetItem().getAttributes().getAttribute(this.attributeKey);
            if (attribute == null) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            for (String value : attribute) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(value);
            }
            return buf.toString();
        }
    }
}

