/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.DesmodojsSpace;
import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.LinkedHashSet;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class ParameterCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Parameter";
    public static final String NAME_PARAMNAME = "name";
    public static final String VALUE_PARAMNAME = "value";
    public static final String VALUES_PARAMNAME = "values";
    public static final String INDEXRELATIONS_PARAMVALUE = "indexrelations";
    public static final String TABLEEXPORT_PARAMVALUE = "tableexport";
    public static final String NEWRESOURCE_PARAMVALUE = "newresource";
    public static final String CORPUSLIST_PARAMVALUE = "corpuslist";
    private Atlas atlas;
    private AttributeChange attributeChange;

    public ParameterCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes((Object)this.atlas.getTermThesaurus().getThesaurusMetadata(), this.attributeChange);
        }
        this.setDone("_ done.desmography.parameter", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        this.atlas = DesmographyUtils.getAtlas(this.requestHandler);
        String name = this.getMandatory(NAME_PARAMNAME);
        AttributeKey attributeKey = this.getAttributeKey(name);
        if (attributeKey == null) {
            throw BdfErrors.error((String)"_ error.unknown.parametervalue", (Object[])new Object[]{NAME_PARAMNAME, name});
        }
        String[] values = this.getValues();
        this.attributeChange = this.getAttributeChange(attributeKey, values);
    }

    private String[] getValues() throws ErrorMessageException {
        String[] multiValues;
        String[] simpleValues;
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>();
        for (String value : simpleValues = this.requestHandler.getTokens(VALUE_PARAMNAME)) {
            resultSet.add(value);
        }
        for (String multiValue : multiValues = this.requestHandler.getTokens(VALUES_PARAMNAME)) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens((String)multiValue, (boolean)true)) {
                resultSet.add(token);
            }
        }
        return resultSet.toArray(new String[resultSet.size()]);
    }

    private AttributeChange getAttributeChange(AttributeKey attributeKey, String[] values) throws ErrorMessageException {
        AttributeChangeBuilder builder = new AttributeChangeBuilder();
        for (String value : values) {
            builder.appendValue(attributeKey, value);
        }
        if (!builder.containsValue(attributeKey)) {
            builder.putRemovedAttributeKey(attributeKey);
        }
        return builder.toAttributeChange();
    }

    private AttributeKey getAttributeKey(String name) {
        switch (name) {
            case "indexrelations": {
                return DesmodojsSpace.INDEXRELATIONS_KEY;
            }
            case "tableexport": {
                return DesmographySpace.TABLEEXPORT_KEY;
            }
            case "newresource": {
                return DesmodojsSpace.NEWRESOURCE_KEY;
            }
            case "corpuslist": {
                return DesmodojsSpace.CORPUSLIST_KEY;
            }
        }
        return null;
    }
}

