/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIOException;

public class StringSXContentSource
implements SXContentSource {
    String formatName;
    String contentBody;

    public StringSXContentSource(String formatName, String contentBody) {
        this.formatName = formatName;
        this.contentBody = contentBody;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public void writeContent(OutputStream outputStream) throws SXIOException {
        try {
            int n;
            ByteArrayInputStream input = new ByteArrayInputStream(this.contentBody.getBytes(this.getEncoding()));
            byte[] buffer = new byte[1004];
            while ((n = input.read(buffer)) != -1) {
                outputStream.write(buffer, 0, n);
            }
            input.close();
        }
        catch (IOException ioe) {
            throw new SXIOException(ioe);
        }
    }

    @Override
    public boolean needDeclaration() {
        return true;
    }

    @Override
    public boolean needRootElement() {
        return true;
    }
}

