/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.boxes.TextBoxManager;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Chapeau;
import net.mapeadores.util.awt.FontInfo;
import net.mapeadores.util.geometry.CartesianOrigin;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.geometry.CartesianUtils;

public class ChapeauxLayer {
    private int east = 10;
    private int west = -10;
    private int north = 10;
    private int south = -10;
    private ArrayList chapeauItemList = new ArrayList();
    private TextBoxManager textBoxManager;
    private int width;
    private int height;

    public ChapeauxLayer(TextBoxManager textBoxManager) {
        this.textBoxManager = textBoxManager;
    }

    public Set getUsedBoxSkin() {
        HashSet<BoxSkin> set = new HashSet<BoxSkin>();
        for (ChapeauItem chapeauItem : this.chapeauItemList) {
            set.add(chapeauItem.textBox.getBoxSkin());
        }
        return set;
    }

    public List getChapeauItemList() {
        return this.chapeauItemList;
    }

    public void reinit(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin) {
        this.chapeauItemList.clear();
        this.width = cartesianOrigin.getGraphicX() * 2;
        this.height = cartesianOrigin.getGraphicY() * 2;
        CartesianPoint cartesianCenter = faisceauAngulaire.getCartesianCenter();
        int chapeauCount = faisceauAngulaire.getChapeauCount();
        for (int i = 0; i < chapeauCount; ++i) {
            Chapeau chapeau = faisceauAngulaire.getChapeau(i);
            CartesianUtils.Intersection intersection = CartesianUtils.getAngleIntersection((CartesianPoint)cartesianCenter, (double)chapeau.getCartesianAngle(), (int)this.east, (int)this.west, (int)this.north, (int)this.south);
            Point graphicPoint = cartesianOrigin.toGraphicPoint(intersection.getCartesianPoint());
            this.chapeauItemList.add(new ChapeauItem(chapeau, graphicPoint, intersection.getIntersectedDirection()));
        }
    }

    public void redim(Dimension dim, FontInfo fontInfo) {
        this.east = dim.width / 2 - fontInfo.getAscent() - 1;
        this.west = -this.east;
        this.north = dim.height / 2 - fontInfo.getAscent() - 1;
        this.south = -dim.height / 2 + fontInfo.getDescent();
    }

    public void clear() {
        this.chapeauItemList.clear();
    }

    public class ChapeauItem {
        Point A;
        String text;
        int orientation;
        TextBox textBox;
        int lineAscent;

        ChapeauItem(Chapeau chapeau, Point A, int direction) {
            this.A = A;
            this.textBox = ChapeauxLayer.this.textBoxManager.getTextBox((short)-1, chapeau.getSecteur().getSecteurTerm().getCode());
            TextBox.Line line0 = this.textBox.getLine(0);
            this.lineAscent = line0.getLineAscent();
            this.text = line0.getLineString();
            Dimension dim = this.textBox.getDimension();
            int lg = dim.width;
            if (direction == 1 || direction == 5) {
                this.orientation = 0;
                A.x -= lg / 2;
                if (A.x + lg > ChapeauxLayer.this.width) {
                    A.x = ChapeauxLayer.this.width - lg;
                } else if (A.x < 0) {
                    A.x = 0;
                }
            } else if (direction == 3) {
                this.orientation = 112;
                A.y -= lg / 2;
                if (A.y + lg > ChapeauxLayer.this.height) {
                    A.y = ChapeauxLayer.this.height - lg;
                } else if (A.y < 0) {
                    A.y = 0;
                }
            } else {
                this.orientation = 111;
                A.y += lg / 2;
                if (A.y - lg < 0) {
                    A.y = lg;
                } else if (A.y + lg > ChapeauxLayer.this.height) {
                    A.y = ChapeauxLayer.this.height;
                }
            }
        }

        public Point getGraphicAncragePoint() {
            return this.A;
        }

        public String getText() {
            return this.text;
        }

        public TextBox getTextBox() {
            return this.textBox;
        }

        public int getOrientation() {
            return this.orientation;
        }
    }
}

