/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.conf;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.conf.ConfEvent;
import net.desmodo.atlas.conf.ConfListener;
import net.desmodo.atlas.conf.ConfUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.misc.ArrayUtils;
import net.mapeadores.util.primitives.PositiveInteger;

public class AbstractConf
implements Conf,
Cloneable {
    public static final short OBSOLETEKEY_RESULT = 2;
    public static final short OK_RESULT = 1;
    public static final short UNKNOWNKEY_RESULT = -1;
    public static final short BADVALUE_RESULT = -2;
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private ConfListener[] confListeners = new ConfListener[0];
    private boolean eventsQueued = false;
    private final List<String> queuedEventList = new ArrayList<String>();
    private final Map<String, String> unknownKeyMap = new LinkedHashMap<String, String>();

    protected void addAll(AbstractConf confMap) {
        for (Map.Entry<String, Object> entry : confMap.map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                this.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof File) {
                this.putDirectory(key, new File(((File)value).getPath()));
                continue;
            }
            if (value instanceof Integer) {
                this.putInteger(key, (Integer)value);
                continue;
            }
            if (value instanceof PositiveInteger) {
                this.putPositiveInteger(key, ((PositiveInteger)value).intValue());
                continue;
            }
            if (value instanceof String) {
                this.putString(key, (String)value);
                continue;
            }
            if (value instanceof Font) {
                this.putFont(key, (Font)value);
                continue;
            }
            if (value instanceof Rectangle) {
                this.putRectangle(key, new Rectangle((Rectangle)value));
                continue;
            }
            if (value instanceof Lang) {
                this.putLang(key, (Lang)value);
                continue;
            }
            if (value instanceof MessageFormat) {
                this.putMessageFormat(key, (MessageFormat)((MessageFormat)value).clone());
                continue;
            }
            if (value instanceof FileWrapper) {
                this.putFile(key, ((FileWrapper)value).getFile());
                continue;
            }
            if (value instanceof String[]) {
                String[] val = (String[])value;
                String[] copy = new String[val.length];
                System.arraycopy(val, 0, copy, 0, val.length);
                this.putStringArray(key, copy);
                continue;
            }
            if (value instanceof URLWrapper) {
                this.putURL(key, ((URLWrapper)value).getURL());
                continue;
            }
            throw new IllegalArgumentException("La valeur de cl\u00e9 " + key + " appartient \u00e0 un classe (" + value.getClass().getName() + ") inconnue de Conf Map");
        }
    }

    public void addConfListener(ConfListener confListener) {
        this.confListeners = (ConfListener[])ArrayUtils.addUnique((Object[])this.confListeners, (Object)confListener, (Object[])new ConfListener[this.confListeners.length + 1]);
    }

    public void removeConfListener(ConfListener confListener) {
        if (this.confListeners.length > 0) {
            this.confListeners = (ConfListener[])ArrayUtils.removeUnique((Object[])this.confListeners, (Object)confListener, (Object[])new ConfListener[this.confListeners.length - 1]);
        }
    }

    protected void fireConfChanged(String param) {
        if (this.eventsQueued) {
            this.queuedEventList.add(param);
        } else {
            ConfEvent confEvent = new ConfEvent((Conf)this, param);
            for (ConfListener confListener : this.confListeners) {
                confListener.confChanged(confEvent);
            }
        }
    }

    protected void putBoolean(String name, boolean b) {
        this.put(name, b);
    }

    protected void putDirectory(String name, File f) {
        this.put(name, f);
    }

    protected void putInteger(String name, int i) {
        this.put(name, i);
    }

    protected void putPositiveInteger(String name, int i) {
        this.put(name, new PositiveInteger(i));
    }

    protected void putString(String name, String s) {
        this.put(name, s);
    }

    protected void putFont(String name, Font f) {
        this.put(name, f);
    }

    protected void putRectangle(String name, Rectangle rectangle) {
        this.put(name, rectangle);
    }

    protected void putLang(String name, Lang lang) {
        this.put(name, lang);
    }

    protected void putMessageFormat(String name, MessageFormat messageFormat) {
        this.put(name, messageFormat);
    }

    protected void putFile(String name, File f) {
        this.put(name, new FileWrapper(f));
    }

    protected void putStringArray(String name, String[] stringArray) {
        this.put(name, stringArray);
    }

    protected void putURL(String name, URL url) {
        this.put(name, new URLWrapper(url));
    }

    @Override
    public boolean isTransient(String name) {
        return false;
    }

    @Override
    public boolean getBoolean(String name) {
        Boolean bool = (Boolean)this.get(name);
        return bool;
    }

    @Override
    public File getDirectory(String name) {
        File file = (File)this.get(name);
        return file;
    }

    @Override
    public int getInteger(String name) {
        Integer itg = (Integer)this.get(name);
        return itg;
    }

    @Override
    public int getPositiveInteger(String name) {
        PositiveInteger itg = (PositiveInteger)this.get(name);
        return itg.intValue();
    }

    @Override
    public String getString(String name) {
        String s = (String)this.get(name);
        return s;
    }

    @Override
    public Font getFont(String name) {
        Font f = (Font)this.get(name);
        return f;
    }

    @Override
    public Rectangle getRectangle(String name) {
        Rectangle rectangle = (Rectangle)this.get(name);
        return rectangle;
    }

    @Override
    public Lang getLang(String name) {
        Lang lang = (Lang)this.get(name);
        return lang;
    }

    @Override
    public MessageFormat getMessageFormat(String name) {
        MessageFormat mf = (MessageFormat)this.get(name);
        return (MessageFormat)mf.clone();
    }

    @Override
    public File getFile(String name) {
        FileWrapper fileWrapper = (FileWrapper)this.get(name);
        return fileWrapper.getFile();
    }

    @Override
    public String[] getStringArray(String name) {
        String[] stringArray = (String[])this.get(name);
        return stringArray;
    }

    @Override
    public URL getURL(String name) {
        URLWrapper urlWrapper = (URLWrapper)this.get(name);
        return urlWrapper.getURL();
    }

    @Override
    public Map<String, String> toStringMap(boolean excludeTransient) {
        String key;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            key = entry.getKey();
            if (excludeTransient && this.isTransient(key)) continue;
            result.put(key, ConfUtils.toString(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.unknownKeyMap.entrySet()) {
            key = entry.getKey();
            if (excludeTransient && this.isTransient(key)) continue;
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    public void setBoolean(String name, boolean b) {
        Boolean bool = (Boolean)this.get(name);
        if (bool != b) {
            this.put(name, b);
            this.fireConfChanged(name);
        }
    }

    public void setDirectory(String name, File f) {
        File file = (File)this.get(name);
        if (!f.isDirectory() && (f = f.getParentFile()) == null) {
            throw new IllegalArgumentException("File f is not a directory and has no parent file");
        }
        if (!file.equals(f)) {
            this.put(name, f);
            this.fireConfChanged(name);
        }
    }

    public void setInteger(String name, int i) {
        Integer itg = (Integer)this.get(name);
        if (itg != i) {
            this.put(name, i);
            this.fireConfChanged(name);
        }
    }

    public void setPositiveInteger(String name, int i) {
        if (i <= 0) {
            return;
        }
        PositiveInteger itg = (PositiveInteger)this.get(name);
        if (itg.intValue() != i) {
            this.put(name, new PositiveInteger(i));
            this.fireConfChanged(name);
        }
    }

    public void setString(String name, String s) {
        String value = (String)this.get(name);
        if (!value.equals(s)) {
            this.put(name, s);
            this.fireConfChanged(name);
        }
    }

    public void setFont(String name, Font f) {
        Font value = (Font)this.get(name);
        if (!value.equals(f)) {
            this.put(name, f);
            this.fireConfChanged(name);
        }
    }

    public void setRectangle(String name, Rectangle rectangle) {
        Rectangle value = (Rectangle)this.get(name);
        if (!value.equals(rectangle)) {
            this.put(name, rectangle);
            this.fireConfChanged(name);
        }
    }

    public void setLang(String name, Lang lang) {
        Lang currentLang = (Lang)this.get(name);
        if (!currentLang.equals((Object)lang)) {
            this.put(name, lang);
            this.fireConfChanged(name);
        }
    }

    public void setMessageFormat(String name, MessageFormat messageFormat) {
        MessageFormat mf = (MessageFormat)this.get(name);
        if (!mf.equals(messageFormat)) {
            this.put(name, messageFormat);
            this.fireConfChanged(name);
        }
    }

    public void setFile(String name, File f) {
        FileWrapper fileWrapper = (FileWrapper)this.get(name);
        if (f != null && f.isDirectory()) {
            throw new IllegalArgumentException("File f is a directory");
        }
        if (fileWrapper.replaceFile(f)) {
            this.fireConfChanged(name);
        }
    }

    public void setStringArray(String name, String[] stringArray) {
        boolean dif;
        String[] currentArray = (String[])this.get(name);
        boolean bl = dif = currentArray.length != stringArray.length;
        if (!dif) {
            for (int i = 0; i < currentArray.length; ++i) {
                if (currentArray[i].equals(stringArray[i])) continue;
                dif = true;
                break;
            }
        }
        if (dif) {
            this.put(name, stringArray);
            this.fireConfChanged(name);
        }
    }

    public void setURL(String name, URL url) {
        URLWrapper urlBundle = (URLWrapper)this.get(name);
        if (urlBundle.replaceURL(url)) {
            this.fireConfChanged(name);
        }
    }

    public String getAlias(String name) {
        return null;
    }

    public boolean isObsolete(String name) {
        return false;
    }

    public short set(String name, String value) {
        Integer itg;
        File f;
        if (value == null) {
            return -2;
        }
        Object currentValue = this.map.get(name);
        if (currentValue == null) {
            String alias = this.getAlias(name);
            if (alias == null) {
                if (!this.isObsolete(name)) {
                    this.unknownKeyMap.put(name, value);
                    return -1;
                }
                return 2;
            }
            name = alias;
            currentValue = this.map.get(alias);
        }
        if (currentValue instanceof Boolean) {
            Boolean b = ConfUtils.booleanTest(value);
            if (b == null) {
                return -2;
            }
            this.setBoolean(name, b);
        } else if (currentValue instanceof File) {
            f = ConfUtils.directoryTest(value);
            if (f == null) {
                return -2;
            }
            this.setDirectory(name, f);
        } else if (currentValue instanceof Integer) {
            itg = ConfUtils.integerTest(value);
            if (itg == null) {
                return -2;
            }
            this.setInteger(name, itg);
        } else if (currentValue instanceof PositiveInteger) {
            itg = ConfUtils.positiveIntegerTest(value);
            if (itg == null) {
                return -2;
            }
            this.setPositiveInteger(name, itg);
        } else if (currentValue instanceof String) {
            this.setString(name, value);
        } else if (currentValue instanceof Font) {
            this.setFont(name, ConfUtils.toFont(value));
        } else if (currentValue instanceof Rectangle) {
            this.setRectangle(name, ConfUtils.toRectangle(value));
        } else if (currentValue instanceof Lang) {
            Lang lang = ConfUtils.langTest(value);
            if (lang == null) {
                return -2;
            }
            this.setLang(name, lang);
        } else if (currentValue instanceof MessageFormat) {
            MessageFormat messageFormat = ConfUtils.messageFormatTest(value);
            if (messageFormat == null) {
                return -2;
            }
            this.setMessageFormat(name, messageFormat);
        } else if (currentValue instanceof FileWrapper) {
            if (value.length() == 0) {
                this.setFile(name, null);
            } else {
                f = new File(value);
                if (f.isDirectory()) {
                    return 1;
                }
                this.setFile(name, f);
            }
        } else if (currentValue instanceof String[]) {
            this.setStringArray(name, ConfUtils.toStringArray(value));
        } else if (currentValue instanceof URLWrapper) {
            if (value.length() == 0) {
                this.setURL(name, null);
            } else {
                try {
                    URL url = new URL(value);
                    this.setURL(name, url);
                }
                catch (MalformedURLException mue) {
                    return -2;
                }
            }
        } else {
            throw new IllegalArgumentException("La valeur de cl\u00e9 " + name + " appartient \u00e0 un classe (" + value.getClass().getName() + ") inconnue de Conf Map");
        }
        return 1;
    }

    public void saveIntoProperties(Properties properties, String suffixe) {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String key = entry.getKey();
            if (this.isTransient(key)) continue;
            if (suffixe != null) {
                key = suffixe + key;
            }
            properties.put(key, ConfUtils.toString(entry.getValue()));
        }
    }

    public void queueEvents() {
        this.eventsQueued = true;
    }

    public void flushEvents() {
        if (this.eventsQueued) {
            this.eventsQueued = false;
            if (this.queuedEventList.size() > 0) {
                ConfEvent confEvent = new ConfEvent((Conf)this, this.queuedEventList);
                this.queuedEventList.clear();
                for (ConfListener confListener : this.confListeners) {
                    confListener.confChanged(confEvent);
                }
            }
        }
    }

    private void put(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null for " + name);
        }
        this.map.put(name, value);
    }

    private Object get(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            throw new IllegalArgumentException("illegal name value : " + name);
        }
        return obj;
    }

    private static class FileWrapper {
        private File file;

        private FileWrapper(File f) {
            this.file = f;
        }

        public String toString() {
            if (this.file == null) {
                return "";
            }
            return this.file.getPath();
        }

        private File getFile() {
            return this.file;
        }

        private boolean replaceFile(File f) {
            if (this.file == null) {
                if (f == null) {
                    return false;
                }
                this.file = f;
                return true;
            }
            if (f == null) {
                this.file = f;
                return true;
            }
            if (f.equals(this.file)) {
                return false;
            }
            this.file = f;
            return true;
        }
    }

    private static class URLWrapper {
        private URL url;

        private URLWrapper(URL url) {
            this.url = url;
        }

        public String toString() {
            if (this.url == null) {
                return "";
            }
            return this.url.toString();
        }

        private URL getURL() {
            return this.url;
        }

        private boolean replaceURL(URL u) {
            if (this.url == null) {
                if (u == null) {
                    return false;
                }
                this.url = u;
                return true;
            }
            if (u == null) {
                this.url = u;
                return true;
            }
            if (u.equals(this.url)) {
                return false;
            }
            this.url = u;
            return true;
        }
    }
}

