/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfext.comptaexemole.CompilImputationPage;
import fr.exemole.bdfext.comptaexemole.DetailImputationPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;

public class ImputationBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final String corpusName;
    private final String detail;
    private final BdfServer bdfServer;

    public ImputationBdfInstruction(BdfServer bdfServer, String corpusName, String detail) {
        this.corpusName = corpusName;
        this.detail = detail;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)1, (String)this.corpusName);
            Corpus corpus = (Corpus)fichotheque.getSubset(subsetKey);
            if (corpus == null) {
                return null;
            }
            if (this.detail == null) {
                return HtmlResponseHandler.init((HtmlProducer)new CompilImputationPage(corpus));
            }
            Thesaurus thesaurus = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)"imputation");
            Motcle motcle = thesaurus.getMotcleByIdalpha(this.detail);
            if (motcle == null) {
                return null;
            }
            return HtmlResponseHandler.init((HtmlProducer)new DetailImputationPage(corpus, motcle));
        }
        catch (ParseException pe) {
            return null;
        }
    }
}

