/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfserver.tools.BH;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class CompilImputationPage
extends PageHtmlPrinter
implements HtmlProducer {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    private final Corpus corpus;
    private Fichotheque fichotheque;
    private Thesaurus imputationThesaurus;
    private final List<FicheMeta> emptyFicheList = new ArrayList<FicheMeta>();
    private final List<FicheMeta> errorFicheList = new ArrayList<FicheMeta>();
    private FieldKey montantFieldKey;
    private FieldKey dateFieldKey;
    private final Map<String, Float> montantMap = new TreeMap<String, Float>();
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.FRENCH);

    public CompilImputationPage(Corpus corpus) {
        this.corpus = corpus;
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.init();
    }

    public void writeHtml(Appendable writer) throws IOException {
        this.initPrinter(writer);
        this.start(DEFAULT_LANG, "Compilation");
        if (this.emptyFicheList.size() > 0) {
            this.H2().__escape((CharSequence)"Imputation non renseign\u00e9e")._H2();
            this.printList(this.emptyFicheList);
        }
        if (this.errorFicheList.size() > 0) {
            this.H2().__escape((CharSequence)"Erreur dans le montant ou la date")._H2();
            this.printList(this.errorFicheList);
        }
        this.H2().__escape((CharSequence)"Totaux")._H2();
        String corpusName = this.corpus.getSubsetName();
        if (corpusName.equals("ligne")) {
            corpusName = "ligne2008";
        }
        HtmlAttributes aAttr = HA.href((CharSequence)"").target("Edition");
        HtmlAttributes spanAttr = HA.style((String)"");
        for (Map.Entry<String, Float> entry : this.montantMap.entrySet()) {
            String key = entry.getKey();
            this.P().A(aAttr.href((CharSequence)(corpusName + "-" + key + ".html"))).__escape((CharSequence)key)._A().__escape((CharSequence)" : ");
            float f = entry.getValue().floatValue();
            if (f > 0.0f) {
                spanAttr.style("color: red");
            } else {
                spanAttr.style("color: blue");
            }
            this.SPAN(spanAttr).__escape((CharSequence)this.numberFormat.format(f))._SPAN()._P();
        }
        this.end();
    }

    private void printList(List<FicheMeta> list) {
        HtmlAttributes aAttr = HA.href((CharSequence)"").target("Edition");
        this.UL();
        for (FicheMeta ficheMeta : list) {
            this.LI().A(aAttr.href((CharSequence)BH.domain((String)"../../edition").page("fiche-change").subsetItem((SubsetItem)ficheMeta))).__escape((CharSequence)ficheMeta.getTitle())._A()._LI();
        }
        this._UL();
    }

    private void init() {
        this.montantFieldKey = FieldKey.build((short)1, (String)"montant");
        this.dateFieldKey = FieldKey.build((short)1, (String)"date");
        this.fichotheque = this.corpus.getFichotheque();
        this.imputationThesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"imputation");
        for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
            Object obj2;
            Croisements motcleCroisements = this.fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)this.imputationThesaurus);
            if (motcleCroisements.isEmpty()) {
                this.emptyFicheList.add(ficheMeta);
                continue;
            }
            FicheAPI fiche = this.corpus.getFicheAPI(ficheMeta, false);
            Motcle motcle = (Motcle)motcleCroisements.getFirstSubsetItem();
            Object obj = fiche.getValue(this.montantFieldKey);
            if (obj == null || !(obj instanceof NumberItem)) {
                this.errorFicheList.add(ficheMeta);
            } else {
                NumberItem numberItem = (NumberItem)obj;
                float f = numberItem.getDecimal().toFloat();
                this.addMontant(motcle, f);
            }
            if ((obj2 = fiche.getValue(this.dateFieldKey)) != null && obj2 instanceof DateItem) continue;
            this.errorFicheList.add(ficheMeta);
        }
    }

    private void addMontant(Motcle motcle, float f) {
        String idalpha = motcle.getIdalpha();
        Float fobj = this.montantMap.get(idalpha);
        fobj = fobj == null ? Float.valueOf(f) : Float.valueOf(fobj.floatValue() + f);
        this.montantMap.put(idalpha, fobj);
    }
}

