/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef;

import java.util.Collection;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.Labels;

public class CefTableInclusionResolver
implements TableInclusionResolver {
    public static final String NAMESPACE = "ext_atelier";

    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler tableExportContentErrorHandler) {
        String nameSpace = tableInclusionDef.getNameSpace();
        return nameSpace.equals(NAMESPACE);
    }

    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        if (!tableInclusionDef.getNameSpace().equals(NAMESPACE)) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        Col[] colArray = new Col[]{TableExportUtils.toCol((ColDef)new AtelierColDef(tableInclusionDef.getLabels()), (SourceFormatter)new AtelierFormatter(tableExportContext.getFichotheque()))};
        return colArray;
    }

    private class AtelierColDef
    implements ColDef {
        private final Labels customLabels;

        private AtelierColDef(Labels customLabels) {
            this.customLabels = customLabels;
        }

        public String getColName() {
            return CefTableInclusionResolver.NAMESPACE;
        }

        public Labels getCustomLabels() {
            return this.customLabels;
        }

        public Object getParameterValue(String paramKey) {
            return null;
        }
    }

    private class AtelierFormatter
    implements SourceFormatter {
        private final FichePointeur personneParAtelierPointeur;
        private final Thesaurus fonctionThesaurus;
        private final Thesaurus atelierThesaurus;
        private final Corpus personneatelierCorpus;

        private AtelierFormatter(Fichotheque fichotheque) {
            this.personneatelierCorpus = FichothequeUtils.getCorpus((Fichotheque)fichotheque, (String)"personneatelier2010");
            this.fonctionThesaurus = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)"fonction0809");
            this.atelierThesaurus = FichothequeUtils.getThesaurus((Fichotheque)fichotheque, (String)"atelierpermanent");
            this.personneParAtelierPointeur = PointeurFactory.newFichePointeur((Corpus)this.personneatelierCorpus);
        }

        public String formatSource(FormatSource formatSource) {
            SubsetItemPointeur pointeur = formatSource.getSubsetItemPointeur();
            if (!(pointeur.getSubset() instanceof Corpus)) {
                return "#ERROR : ext_atelier only for Corpus";
            }
            Croisements fcl = pointeur.getCroisements((Subset)this.personneatelierCorpus);
            StringBuilder buf = new StringBuilder();
            for (Croisements.Entry entry : fcl.getEntryList()) {
                Croisements atelierCroisements;
                FicheMeta fonctionParPersonne = (FicheMeta)entry.getSubsetItem();
                this.personneParAtelierPointeur.setCurrentSubsetItem((SubsetItem)fonctionParPersonne);
                Collection liaisons = CroisementUtils.filter((Croisements)this.personneParAtelierPointeur.getCroisements((Subset)this.fonctionThesaurus), (String)"", (int)8);
                if (liaisons.isEmpty()) continue;
                boolean present = false;
                for (Liaison liaison : liaisons) {
                    Motcle motcle = (Motcle)liaison.getSubsetItem();
                    String idalpha = motcle.getIdalpha();
                    if (!idalpha.startsWith("PAR_") && !idalpha.startsWith("PM_")) continue;
                    present = true;
                    break;
                }
                if (!present || (atelierCroisements = this.personneParAtelierPointeur.getCroisements((Subset)this.atelierThesaurus)).isEmpty()) continue;
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append(((Motcle)atelierCroisements.getFirstSubsetItem()).getIdalpha());
            }
            return buf.toString();
        }
    }
}

