/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.mapeadores.util.primitives.PrimUtils;
import net.mapeadores.util.primitives.io.DataOutputPrimitivesWriter;

public class RandomAccessPrimitivesWriter
extends DataOutputPrimitivesWriter {
    private final RandomAccessFile randomAccessFile;
    private final byte[] intBuffer = new byte[4];
    private final byte[] longBuffer = new byte[8];

    public RandomAccessPrimitivesWriter(RandomAccessFile randomAccessFile) {
        super(randomAccessFile);
        this.randomAccessFile = randomAccessFile;
    }

    @Override
    public void writeInt(int i) throws IOException {
        PrimUtils.convertInt(i, this.intBuffer);
        this.randomAccessFile.write(this.intBuffer, 0, 4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        PrimUtils.convertLong(l, this.longBuffer);
        this.randomAccessFile.write(this.longBuffer, 0, 8);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.randomAccessFile.write(buffer, offset, length);
    }
}

