/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io;

import java.io.File;
import java.util.TreeMap;
import java.util.TreeSet;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.io.ResourceFolderBuilder;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.io.docstream.FileDocStream;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.RelativePath;

public class DirectoryResourceStorage
implements ResourceStorage {
    private final String name;
    protected final File rootDirectory;

    public DirectoryResourceStorage(String name, File rootDirectory) {
        this.name = name;
        this.rootDirectory = rootDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean containsResource(RelativePath path) {
        File file = this.getFile(path.toString(), false);
        return file != null;
    }

    @Override
    public DocStream getResourceDocStream(RelativePath path, MimeTypeResolver mimeTypeResolver) {
        File file = this.getFile(path.toString(), false);
        if (file == null) {
            return null;
        }
        FileDocStream fileDocStream = new FileDocStream(file);
        String mimeType = MimeTypeUtils.getMimeType(mimeTypeResolver, file.getName());
        fileDocStream.setMimeType(mimeType);
        return fileDocStream;
    }

    @Override
    public ResourceFolder getRoot() {
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            return ResourceUtils.EMPTY_ROOTFOLDER;
        }
        return this.getResourceFolder(this.rootDirectory, "");
    }

    @Override
    public ResourceFolder getResourceFolder(RelativePath path) {
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            return null;
        }
        File dir = new File(this.rootDirectory, path.toString());
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return this.getResourceFolder(dir, dir.getName());
    }

    protected File getFile(String normalizedPath, boolean create) {
        File resourceFile = new File(this.rootDirectory, normalizedPath);
        if (create) {
            if (resourceFile.exists() && resourceFile.isDirectory()) {
                return null;
            }
            return resourceFile;
        }
        if (resourceFile.exists() && !resourceFile.isDirectory()) {
            return resourceFile;
        }
        return null;
    }

    private ResourceFolder getResourceFolder(File directory, String folderName) {
        TreeMap<String, ResourceFolder> folderMap = new TreeMap<String, ResourceFolder>();
        TreeSet<String> resourceSet = new TreeSet<String>();
        for (File f : directory.listFiles()) {
            String fileName = f.getName();
            if (f.isDirectory()) {
                if (!ResourceUtils.isValidFolderName(fileName)) continue;
                ResourceFolder folder = this.getResourceFolder(f, fileName);
                folderMap.put(fileName, folder);
                continue;
            }
            if (folderName.isEmpty() || !ResourceUtils.isValidResourceName(fileName)) continue;
            resourceSet.add(fileName);
        }
        return ResourceFolderBuilder.build(folderName, folderMap.values(), resourceSet);
    }
}

