/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.format;

import java.text.ParseException;
import net.mapeadores.util.exceptions.SwitchException;

public class Calcul {
    public static final short DIVISION = 1;
    public static final short ADDITION = 2;
    public static final short SOUSTRACTION = 3;
    public static final short MULTIPLICATION = 4;
    private final short type;
    private final boolean isEntier;
    private final int valeurEntiere;
    private final float valeur;

    Calcul(short type, float valeur) {
        this.type = type;
        this.valeur = valeur;
        this.isEntier = false;
        this.valeurEntiere = 0;
    }

    Calcul(short type, int valeurEntiere) {
        this.type = type;
        this.valeurEntiere = valeurEntiere;
        this.valeur = valeurEntiere;
        this.isEntier = true;
    }

    public static Calcul parse(String s) throws ParseException {
        if ((s = s.trim()).length() < 2) {
            throw new ParseException("Too short", 0);
        }
        short type = 0;
        char carac = s.charAt(0);
        switch (carac) {
            case '+': {
                type = 2;
                break;
            }
            case '-': {
                type = 3;
                break;
            }
            case '*': {
                type = 4;
                break;
            }
            case '/': {
                type = 1;
                break;
            }
            default: {
                throw new ParseException("Missing operator", 0);
            }
        }
        String numero = s.substring(1).trim();
        try {
            int valeurEntiere = Integer.parseInt(numero);
            return new Calcul(type, valeurEntiere);
        }
        catch (NumberFormatException nfe) {
            try {
                float valeur = Float.parseFloat(numero);
                return new Calcul(type, valeur);
            }
            catch (NumberFormatException nfe2) {
                throw new ParseException("Not a number", 1);
            }
        }
    }

    public double execute(double d) {
        switch (this.type) {
            case 2: {
                return d + (double)this.valeur;
            }
            case 3: {
                return d - (double)this.valeur;
            }
            case 4: {
                return d * (double)this.valeur;
            }
            case 1: {
                return d / (double)this.valeur;
            }
        }
        throw new SwitchException("unknwon type = " + this.type);
    }

    public float execute(float d) {
        switch (this.type) {
            case 2: {
                return d + this.valeur;
            }
            case 3: {
                return d - this.valeur;
            }
            case 4: {
                return d * this.valeur;
            }
            case 1: {
                return d / this.valeur;
            }
        }
        throw new SwitchException("unknwon type = " + this.type);
    }

    public long execute(long l) {
        if (!this.isEntier) {
            return (long)this.execute((double)l);
        }
        switch (this.type) {
            case 2: {
                return l + (long)this.valeurEntiere;
            }
            case 3: {
                return l - (long)this.valeurEntiere;
            }
            case 4: {
                return l * (long)this.valeurEntiere;
            }
            case 1: {
                return l / (long)this.valeurEntiere;
            }
        }
        throw new SwitchException("unknwon type = " + this.type);
    }

    public int execute(int i) {
        if (!this.isEntier) {
            return (int)this.execute((float)i);
        }
        switch (this.type) {
            case 2: {
                return i + this.valeurEntiere;
            }
            case 3: {
                return i - this.valeurEntiere;
            }
            case 4: {
                return i * this.valeurEntiere;
            }
            case 1: {
                return i / this.valeurEntiere;
            }
        }
        throw new SwitchException("unknwon type = " + this.type);
    }
}

