/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.opendocument.elements.Constants;
import net.mapeadores.opendocument.elements.OdAttribute;
import net.mapeadores.opendocument.elements.OdLibException;
import net.mapeadores.opendocument.elements.PropertiesElementUtils;

public class OdAttributeMap
implements Constants {
    private static final Map<String, OdAttribute> map = new HashMap<String, OdAttribute>();

    private OdAttributeMap() {
    }

    public static short nameSpaceToShort(String nameSpace) {
        if (nameSpace.equals("fo")) {
            return 11;
        }
        if (nameSpace.equals("style")) {
            return 12;
        }
        if (nameSpace.equals("text")) {
            return 13;
        }
        if (nameSpace.equals("table")) {
            return 14;
        }
        if (nameSpace.equals("svg")) {
            return 15;
        }
        if (nameSpace.equals("draw")) {
            return 16;
        }
        throw new IllegalArgumentException("unknown nameSpace =" + nameSpace);
    }

    public static OdAttribute getAttribute(int[] typeOrder, String name) {
        for (int i = 0; i < typeOrder.length; ++i) {
            OdAttribute attribute = OdAttributeMap.getAttribute(typeOrder[i], name);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    private static OdAttribute getAttribute(int type, String name) {
        return map.get(OdAttributeMap.toKey(type, name));
    }

    private static void init() {
        OdAttributeMap.init("style.txt", 1);
        OdAttributeMap.init("listlevel.txt", 10);
        OdAttributeMap.init("liststyle.txt", 11);
        for (int i = 0; i < PropertiesElementUtils.count(); ++i) {
            int type = PropertiesElementUtils.getAttributesType(i);
            String fileName = PropertiesElementUtils.getFileName(i);
            OdAttributeMap.init(fileName, type);
        }
    }

    private static void init(String ressource, int type) {
        try {
            String ligne;
            InputStream inputStream = OdAttribute.class.getResourceAsStream("resources/" + ressource);
            if (inputStream == null) {
                throw new IllegalStateException("missing : " + ressource);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            short currentNameSpace = 11;
            while ((ligne = reader.readLine()) != null) {
                if ((ligne = ligne.trim()).length() == 0) continue;
                if (ligne.charAt(0) == '#') {
                    currentNameSpace = OdAttributeMap.nameSpaceToShort(ligne.substring(1));
                    continue;
                }
                String key = OdAttributeMap.toKey(type, ligne);
                OdAttribute attr = new OdAttribute(type, ligne, currentNameSpace);
                map.put(key, attr);
            }
        }
        catch (IOException ioe) {
            throw new OdLibException(ioe);
        }
    }

    public static String nameSpaceToString(short nameSpace) {
        switch (nameSpace) {
            case 11: {
                return "fo";
            }
            case 12: {
                return "style";
            }
            case 13: {
                return "text";
            }
            case 14: {
                return "table";
            }
            case 15: {
                return "svg";
            }
            case 16: {
                return "draw";
            }
        }
        throw new IllegalArgumentException("unknown nameSpace =" + nameSpace);
    }

    private static String toKey(int type, String name) {
        return type + ":" + name;
    }

    static {
        OdAttributeMap.init();
    }
}

