/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.FicheConditionPredicateFactory;
import net.fichotheque.utils.selection.FicheSelectEngine;
import net.fichotheque.utils.selection.FilteredCroisementBuilder;
import net.fichotheque.utils.selection.MotcleConditionPredicateFactory;

public class FicheSelectorBuilder {
    private final SelectionContext selectionContext;
    private final Fichotheque fichotheque;
    private final Map<SubsetKey, UnitBuilder> unitBuilderMap = new HashMap<SubsetKey, UnitBuilder>();
    private final List<Corpus> corpusList = new ArrayList<Corpus>();
    private int engineCount = 0;

    public FicheSelectorBuilder(SelectionContext selectionContext) {
        this.selectionContext = selectionContext;
        this.fichotheque = selectionContext.getFichotheque();
    }

    public FicheSelectorBuilder add(FicheQuery ficheQuery) {
        return this.add(ficheQuery, null);
    }

    public FicheSelectorBuilder add(FicheQuery ficheQuery, CroisementCondition croisementCondition) {
        RelationPredicate relationPredicate = this.toRelationPredicate(ficheQuery);
        List<Corpus> resolvedCorpusList = this.resolveCorpusList(ficheQuery.getCorpusCondition());
        for (Corpus corpus : resolvedCorpusList) {
            UnitBuilder unitBuilder = this.checkCorpus(corpus);
            unitBuilder.add(ficheQuery, croisementCondition, relationPredicate);
        }
        ++this.engineCount;
        return this;
    }

    private List<Corpus> resolveCorpusList(SubsetCondition corpusCondition) {
        Corpus currentCorpus = this.selectionContext.getCurrentCorpus();
        SubsetKey currentKey = null;
        if (currentCorpus != null) {
            currentKey = currentCorpus.getSubsetKey();
        }
        Predicate<Subset> corpusPredicate = this.selectionContext.getSubsetAccessPredicate();
        ArrayList<Corpus> result = new ArrayList<Corpus>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            if (!corpusPredicate.test(corpus) || !corpusCondition.accept(corpus.getSubsetKey(), currentKey)) continue;
            result.add(corpus);
        }
        return result;
    }

    public FicheSelectorBuilder addAll(Collection<FicheCondition.Entry> entries) {
        for (FicheCondition.Entry entry : entries) {
            this.add(entry.getFicheQuery(), entry.getCroisementCondition());
        }
        return this;
    }

    public FicheSelector toFicheSelector() {
        if (this.engineCount == 0) {
            return FicheSelectorBuilder.init(this.selectionContext).add(SelectionUtils.EMPTY_FICHEQUERY).toFicheSelector();
        }
        List<Corpus> finalCorpusList = FichothequeUtils.wrap(this.corpusList.toArray(new Corpus[this.corpusList.size()]));
        HashMap<SubsetKey, Unit> finalMap = new HashMap<SubsetKey, Unit>();
        for (Map.Entry<SubsetKey, UnitBuilder> entry : this.unitBuilderMap.entrySet()) {
            finalMap.put(entry.getKey(), entry.getValue().toUnit());
        }
        return new InternalFicheSelector(finalCorpusList, finalMap, this.selectionContext.getFichePredicate());
    }

    private UnitBuilder checkCorpus(Corpus corpus) {
        UnitBuilder unitBuilder = this.unitBuilderMap.get(corpus.getSubsetKey());
        if (unitBuilder == null) {
            unitBuilder = new UnitBuilder(corpus);
            this.unitBuilderMap.put(corpus.getSubsetKey(), unitBuilder);
            this.corpusList.add(corpus);
        }
        return unitBuilder;
    }

    private RelationPredicate toRelationPredicate(FicheQuery ficheQuery) {
        MotcleCondition motcleCondition = ficheQuery.getMotcleCondition();
        Predicate<FicheMeta> motcleConditionPredicate = motcleCondition != null ? MotcleConditionPredicateFactory.newInstance(this.selectionContext, motcleCondition) : null;
        FicheCondition ficheCondition = ficheQuery.getFicheCondition();
        Predicate<SubsetItem> ficheConditionPredicate = ficheCondition != null ? FicheConditionPredicateFactory.newInstance(this.selectionContext, ficheCondition) : null;
        if (motcleConditionPredicate == null && ficheConditionPredicate == null) {
            return null;
        }
        return new RelationPredicate(motcleConditionPredicate, ficheConditionPredicate);
    }

    public static FicheSelectorBuilder init(SelectionContext selectionContext) {
        return new FicheSelectorBuilder(selectionContext);
    }

    private static class RelationPredicate
    implements Predicate<FicheMeta> {
        private final Predicate<FicheMeta> motcleConditionPredicate;
        private final Predicate<SubsetItem> ficheConditionPredicate;

        private RelationPredicate(Predicate<FicheMeta> motcleConditionPredicate, Predicate<SubsetItem> ficheConditionPredicate) {
            this.motcleConditionPredicate = motcleConditionPredicate;
            this.ficheConditionPredicate = ficheConditionPredicate;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            if (this.motcleConditionPredicate != null && !this.motcleConditionPredicate.test(ficheMeta)) {
                return false;
            }
            return this.ficheConditionPredicate == null || this.ficheConditionPredicate.test(ficheMeta);
        }
    }

    private class UnitBuilder {
        private final Corpus corpus;
        private final List<FicheSelectEngine> engineList = new ArrayList<FicheSelectEngine>();

        private UnitBuilder(Corpus corpus) {
            this.corpus = corpus;
        }

        private void add(FicheQuery ficheQuery, CroisementCondition croisementCondition, Predicate<FicheMeta> relationPredicate) {
            this.engineList.add(FicheSelectEngine.newInstance(this.corpus.getCorpusMetadata(), ficheQuery, croisementCondition, FicheSelectorBuilder.this.selectionContext, relationPredicate));
        }

        private Unit toUnit() {
            FicheSelectEngine[] array = this.engineList.toArray(new FicheSelectEngine[this.engineList.size()]);
            return new Unit(PointeurFactory.newFichePointeur(this.corpus), array);
        }
    }

    private static class Unit {
        private final FichePointeur fichePointeur;
        private final FicheSelectEngine[] array;

        private Unit(FichePointeur fichePointeur, FicheSelectEngine[] array) {
            this.fichePointeur = fichePointeur;
            this.array = array;
        }

        private boolean isSelected(FicheMeta ficheMeta) {
            this.fichePointeur.setCurrentSubsetItem(ficheMeta);
            for (FicheSelectEngine ficheSelectEngine : this.array) {
                if (!ficheSelectEngine.isSelected(this.fichePointeur)) continue;
                return true;
            }
            return false;
        }

        private Croisement isSelected(FicheMeta ficheMeta, Croisement croisement) {
            FilteredCroisementBuilder builder = new FilteredCroisementBuilder(croisement);
            this.fichePointeur.setCurrentSubsetItem(ficheMeta);
            for (FicheSelectEngine ficheSelectEngine : this.array) {
                ficheSelectEngine.filter(this.fichePointeur, builder);
            }
            return builder.toCroisement();
        }
    }

    private static class InternalFicheSelector
    implements FicheSelector {
        private final List<Corpus> corpusList;
        private final Map<SubsetKey, Unit> unitMap;
        private final Predicate<FicheMeta> initialPredicate;

        private InternalFicheSelector(List<Corpus> corpusList, Map<SubsetKey, Unit> unitMap, Predicate<FicheMeta> initialPredicate) {
            this.corpusList = corpusList;
            this.unitMap = unitMap;
            this.initialPredicate = initialPredicate;
        }

        @Override
        public List<Corpus> getCorpusList() {
            return this.corpusList;
        }

        @Override
        public Croisement isSelected(FicheMeta ficheMeta, Croisement croisement) {
            if (!this.initialPredicate.test(ficheMeta)) {
                return null;
            }
            Unit unit = this.unitMap.get(ficheMeta.getSubsetKey());
            if (unit == null) {
                return null;
            }
            return unit.isSelected(ficheMeta, croisement);
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            if (!this.initialPredicate.test(ficheMeta)) {
                return false;
            }
            Unit unit = this.unitMap.get(ficheMeta.getSubsetKey());
            if (unit == null) {
                return false;
            }
            return unit.isSelected(ficheMeta);
        }
    }
}

