/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import java.text.ParseException;
import net.mapeadores.util.text.StringUtils;

public class LienToken {
    private final String text;
    private final String mode;
    private final int weight;

    private LienToken(String text, String mode, int weight) {
        this.text = text;
        this.mode = mode;
        this.weight = weight;
    }

    public String getMode() {
        return this.mode;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getText() {
        return this.text;
    }

    public static LienToken parse(String s) {
        char lastChar = s.charAt(s.length() - 1);
        if (lastChar == '+') {
            return LienToken.parsePlusStyle(s);
        }
        if (lastChar == '>') {
            return LienToken.parseCompleteStyle(s);
        }
        if (lastChar >= '0' && lastChar <= '9') {
            return LienToken.parseNumberStyle(s);
        }
        return new LienToken(s, "", 1);
    }

    private static LienToken parseNumberStyle(String s) {
        char c;
        int i;
        int dizaine = 1;
        int weight = 0;
        int idx = 0;
        for (i = s.length() - 1; i >= 0; --i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (i == 1) {
                    return new LienToken(s, "", 1);
                }
                int p = c - 48;
                weight += p * dizaine;
                dizaine *= 10;
                continue;
            }
            idx = i;
            break;
        }
        for (i = idx; i >= 1; --i) {
            c = s.charAt(i);
            if (c == ' ') continue;
            if (c == '+') {
                return new LienToken(s.substring(0, i).trim(), "", weight + 1);
            }
            if (c != '<') break;
            return new LienToken(s.substring(0, i).trim(), "", weight);
        }
        return new LienToken(s, "", 1);
    }

    private static LienToken parsePlusStyle(String s) {
        int p = 1;
        int lastIdx = s.length() - 1;
        for (int i = lastIdx - 1; i >= 0 && s.charAt(i) == '+'; --i) {
            ++p;
            --lastIdx;
        }
        return new LienToken(s.substring(0, lastIdx).trim(), "", p + 1);
    }

    private static LienToken parseCompleteStyle(String s) {
        int idx = s.lastIndexOf(60);
        if (idx == -1) {
            return new LienToken(s, "", 1);
        }
        String info = s.substring(idx + 1, s.length() - 1).trim();
        String text = s.substring(0, idx).trim();
        int sepIdx = info.indexOf(95);
        if (sepIdx < 0) {
            try {
                int weight = Integer.parseInt(info);
                if (weight < 1) {
                    weight = 1;
                }
                return new LienToken(text, "", weight);
            }
            catch (NumberFormatException nfe) {
                try {
                    StringUtils.checkTechnicalName(info, false);
                    return new LienToken(text, info, 1);
                }
                catch (ParseException pe) {
                    return new LienToken(s, "", 1);
                }
            }
        }
        try {
            int weight = Integer.parseInt(info.substring(sepIdx + 1));
            if (weight < 1) {
                weight = 1;
            }
            String mode = info.substring(0, sepIdx);
            StringUtils.checkTechnicalName(mode, false);
            return new LienToken(text, mode, weight);
        }
        catch (NumberFormatException | ParseException e) {
            return new LienToken(s, "", 1);
        }
    }
}

