/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.SpanParser;
import net.mapeadores.util.text.TypoOptions;

public class TextContentParser {
    private final SpanParser bracketsParser;
    private final SpanParser emphasisParser;
    private final SpanParser httpParser = SpanParser.getHttpParser();
    private final SpanParser wwwParser = SpanParser.getWwwParser();
    private final TypoOptions typoOptions;

    public TextContentParser() {
        this.bracketsParser = null;
        this.emphasisParser = null;
        this.typoOptions = null;
    }

    public TextContentParser(TypoOptions typoOptions) {
        this.bracketsParser = SpanParser.getBracketsParser(typoOptions);
        this.emphasisParser = SpanParser.getEmphasisParser(typoOptions);
        this.typoOptions = typoOptions;
    }

    public void parse(TextContentBuilder textContentBuilder, String token) {
        int length = token.length();
        if (length == 0) {
            return;
        }
        boolean onQuote = false;
        char quoteChar = '\u0000';
        StringBuilder buf = new StringBuilder(token.length());
        block4: for (int i = 0; i < length; ++i) {
            char carac = token.charAt(i);
            if (onQuote) {
                char next;
                buf.append(carac);
                if (carac == quoteChar) {
                    this.flushBuffer(textContentBuilder, buf, false);
                    onQuote = false;
                    continue;
                }
                if (carac != '\\' || i >= length - 1 || (next = token.charAt(i + 1)) != quoteChar) continue;
                buf.append(quoteChar);
                ++i;
                continue;
            }
            SpanParseResult spanParseResult = null;
            if (carac == '\"' && TextContentParser.isInformaticQuote(token, i)) {
                this.flushBuffer(textContentBuilder, buf, true);
                quoteChar = carac;
                onQuote = true;
            } else if (carac == '\'' && TextContentParser.isInformaticQuote(token, i)) {
                this.flushBuffer(textContentBuilder, buf, true);
                quoteChar = carac;
                onQuote = true;
            } else if (carac == '[' && this.bracketsParser != null) {
                spanParseResult = this.bracketsParser.parse(token, i);
            } else if (carac == '{' && this.emphasisParser != null) {
                spanParseResult = this.emphasisParser.parse(token, i);
            } else if (carac == 'h') {
                spanParseResult = this.httpParser.parse(token, i);
            } else if (carac == 'w') {
                spanParseResult = this.wwwParser.parse(token, i);
            }
            if (spanParseResult != null) {
                short state = spanParseResult.getState();
                switch (state) {
                    case 1: {
                        this.flushBuffer(textContentBuilder, buf, true);
                        textContentBuilder.addS(spanParseResult.getSpan());
                        i = spanParseResult.getEndIndex();
                        break;
                    }
                    case 3: {
                        this.flushBuffer(textContentBuilder, buf, true);
                        textContentBuilder.addText(token.substring(i));
                        return;
                    }
                    default: {
                        int ignoreCharCount = spanParseResult.getIgnoreCharCount();
                        if (ignoreCharCount <= 0) continue block4;
                        for (int j = i; j < i + ignoreCharCount; ++j) {
                            buf.append(token.charAt(j));
                        }
                        i = i + ignoreCharCount - 1;
                        break;
                    }
                }
                continue;
            }
            buf.append(carac);
        }
        this.flushBuffer(textContentBuilder, buf, !onQuote);
    }

    private void flushBuffer(TextContentBuilder textContentBuilder, StringBuilder buf, boolean withTypo) {
        int bufLength = buf.length();
        if (bufLength > 0) {
            String text = withTypo && this.typoOptions != null ? TypoParser.parseTypo(buf, 0, bufLength, this.typoOptions) : buf.toString();
            textContentBuilder.addText(text);
            buf.delete(0, bufLength);
        }
    }

    private static boolean isInformaticQuote(String token, int currentIndex) {
        if (currentIndex == 0) {
            return false;
        }
        for (int i = currentIndex - 1; i >= 0; --i) {
            char carac = token.charAt(i);
            if (carac == ' ') continue;
            switch (carac) {
                case '(': 
                case '=': 
                case '[': 
                case '{': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

