/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.parsers.DynamicEdit;
import net.fichotheque.tools.parsers.DynamicEditFactory;
import net.fichotheque.tools.parsers.ParseContext;
import net.fichotheque.tools.parsers.croisement.LienBufferParser;
import net.fichotheque.tools.parsers.croisement.WeightMotcleToken;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class CroisementParseEngine {
    private static final int MAX_RANGELENGTH = 50;
    private final Set<IncludeKey> mainScope = new HashSet<IncludeKey>();
    private final List<Buffer> mainBufferList = new ArrayList<Buffer>();
    private final Set<IncludeKey> masterScope = new HashSet<IncludeKey>();
    private final List<Buffer> masterBufferList = new ArrayList<Buffer>();
    private final List<String[]> liageValuesList = new ArrayList<String[]>();
    private final FicheMeta mainFicheMeta;
    private final Lang workingLang;
    private final ParseContext parseContext;
    private final FichothequeEditor fichothequeEditor;
    private final Fichotheque fichotheque;
    private final SubsetItem masterSubsetItem;
    private final Predicate<Subset> subsetAccessPredicate;
    private CroisementChangeEngine mainChange;
    private CroisementChangeEngine appendChange;

    private CroisementParseEngine(FicheMeta ficheMeta, ParseContext parseContext, Lang workingLang) {
        this.mainFicheMeta = ficheMeta;
        this.parseContext = parseContext;
        this.fichothequeEditor = parseContext.getFichothequeEditor();
        this.fichotheque = parseContext.getFichotheque();
        this.workingLang = workingLang;
        this.subsetAccessPredicate = parseContext.getSubsetAccessPredicate();
        Subset masterSubset = ficheMeta.getCorpus().getMasterSubset();
        this.masterSubsetItem = masterSubset != null && this.subsetAccessPredicate.test(masterSubset) ? masterSubset.getSubsetItemById(ficheMeta.getId()) : null;
    }

    CroisementChangeEngine getMainChange() {
        return this.mainChange;
    }

    CroisementChangeEngine getAppendChange() {
        if (this.appendChange == null) {
            this.appendChange = CroisementChangeEngine.appendEngine(this.mainFicheMeta);
        }
        return this.appendChange;
    }

    private void addLiage(String[] values) {
        this.liageValuesList.add(values);
    }

    private void add(ExtendedIncludeKey includeKey, String[] values) {
        Subset subset = this.fichotheque.getSubset(includeKey.getSubsetKey());
        if (subset == null) {
            return;
        }
        if (!this.subsetAccessPredicate.test(subset)) {
            return;
        }
        if (includeKey.isMaster()) {
            if (this.masterSubsetItem != null) {
                IncludeKey root = includeKey.getRootIncludeKey();
                this.masterScope.add(root);
                this.masterBufferList.add(new Buffer(subset, root, values));
            }
        } else {
            IncludeKey root = includeKey.getRootIncludeKey();
            this.mainScope.add(root);
            this.mainBufferList.add(new Buffer(subset, root, values));
        }
    }

    private void run() {
        if (!this.liageValuesList.isEmpty()) {
            for (Corpus corpus : this.fichotheque.getCorpusList()) {
                if (!this.subsetAccessPredicate.test(corpus)) continue;
                this.mainScope.add(IncludeKey.newInstance(corpus.getSubsetKey()));
            }
        }
        this.mainChange = CroisementChangeEngine.clearExistingEngine(this.mainFicheMeta, this.mainScope);
        for (Buffer buffer : this.mainBufferList) {
            if (buffer.isThesaurus()) {
                this.parseThesaurus(this.mainChange, buffer);
                continue;
            }
            this.parseSubset(this.mainChange, buffer);
        }
        for (String[] values : this.liageValuesList) {
            this.parseLiage(values);
        }
        CroisementChanges croisementChanges = this.mainChange.toCroisementChanges();
        if (this.appendChange != null) {
            croisementChanges = new FusionCroisementChanges(croisementChanges, this.appendChange.toCroisementChanges());
        }
        this.fichothequeEditor.getCroisementEditor().updateCroisements(this.mainFicheMeta, croisementChanges);
        if (!this.masterScope.isEmpty()) {
            CroisementChangeEngine masterChange = CroisementChangeEngine.clearExistingEngine(this.masterSubsetItem, this.masterScope);
            for (Buffer buffer : this.masterBufferList) {
                if (buffer.isThesaurus()) {
                    this.parseThesaurus(masterChange, buffer);
                    continue;
                }
                this.parseSubset(masterChange, buffer);
            }
            this.fichothequeEditor.getCroisementEditor().updateCroisements(this.masterSubsetItem, masterChange.toCroisementChanges());
        }
    }

    private void parseLiage(String[] values) {
        Corpus defaultSubset = this.mainFicheMeta.getCorpus();
        for (String value : values) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
                try {
                    LienBuffer lienBuffer = LienBufferParser.parse(this.fichotheque, token, (short)1, defaultSubset, "");
                    if (!this.subsetAccessPredicate.test(lienBuffer.getSubsetItem().getSubset())) continue;
                    this.mainChange.addLien(lienBuffer);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private void parseThesaurus(CroisementChangeEngine croisementChangeEngine, Buffer buffer) {
        Thesaurus thesaurus = (Thesaurus)buffer.subset;
        IncludeKey includeKey = buffer.includeKey;
        Lang thesaurusLang = ThesaurusUtils.checkDisponibility(this.parseContext.getThesaurusLangChecker(), thesaurus, this.workingLang);
        boolean withIdalpha = thesaurus.isIdalphaType();
        DynamicEdit.Parameters parameters = new DynamicEdit.Parameters(this.parseContext, this, thesaurus, includeKey, thesaurusLang);
        DynamicEdit dynamicEdit = DynamicEditFactory.newInstance(parameters);
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        for (String value : buffer.values) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(value, ';', false)) {
                WeightMotcleToken motcleToken = WeightMotcleToken.parse(token, withIdalpha, weightFilter);
                if (motcleToken == null) continue;
                Motcle motcle = WeightMotcleToken.getMotcle(motcleToken, thesaurus, thesaurusLang);
                if (motcle != null) {
                    croisementChangeEngine.addLien(motcle, mode, motcleToken.getWeight());
                    continue;
                }
                if (dynamicEdit == null) continue;
                dynamicEdit.editToken(motcleToken);
            }
        }
    }

    private void parseSubset(CroisementChangeEngine croisementChangeEngine, Buffer buffer) {
        Subset subset = buffer.subset;
        IncludeKey includeKey = buffer.includeKey;
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        for (String value : buffer.values) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
                if (weightFilter > 0) {
                    try {
                        Range range = RangeUtils.parseRange(token);
                        if (range == null) continue;
                        if (range.length() <= 50) {
                            for (int id = range.min(); id <= range.max(); ++id) {
                                SubsetItem subsetItem = subset.getSubsetItemById(id);
                                if (subsetItem == null) continue;
                                croisementChangeEngine.addLien(new LienBuffer(subsetItem, mode, weightFilter));
                            }
                            continue;
                        }
                        int count = 0;
                        for (SubsetItem subsetItem : subset.getSubsetItemList()) {
                            if (range.contains(subsetItem.getId())) {
                                croisementChangeEngine.addLien(new LienBuffer(subsetItem, mode, weightFilter));
                                ++count;
                            }
                            if (count != 50) continue;
                        }
                    }
                    catch (ParseException range) {}
                    continue;
                }
                try {
                    LienBuffer lienBuffer = LienBufferParser.parseId(subset, token, mode, weightFilter);
                    croisementChangeEngine.addLien(lienBuffer);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    public static void run(FicheMeta ficheMeta, RequestMap requestMap, ParseContext parseContext, Lang workingLang) {
        CroisementParseEngine engine = new CroisementParseEngine(ficheMeta, parseContext, workingLang);
        for (String paramName : requestMap.getParameterNameSet()) {
            if (paramName.contains(":")) continue;
            if (paramName.equals("liage")) {
                engine.addLiage(requestMap.getParameterValues(paramName));
                continue;
            }
            try {
                ExtendedIncludeKey extendedIncludeKey = ExtendedIncludeKey.parse(paramName);
                engine.add(extendedIncludeKey, requestMap.getParameterValues(paramName));
            }
            catch (ParseException parseException) {}
        }
        engine.run();
    }

    private static class Buffer {
        private final Subset subset;
        private final IncludeKey includeKey;
        private final String[] values;

        private Buffer(Subset subset, IncludeKey includeKey, String[] values) {
            this.subset = subset;
            this.includeKey = includeKey;
            this.values = values;
        }

        private boolean isThesaurus() {
            return this.subset.getSubsetKey().isThesaurusSubset();
        }
    }

    private static class FusionCroisementChanges
    implements CroisementChanges {
        private final List<SubsetItem> removedList = new ArrayList<SubsetItem>();
        private final List<CroisementChanges.Entry> entryList = new ArrayList<CroisementChanges.Entry>();

        private FusionCroisementChanges(CroisementChanges first, CroisementChanges second) {
            this.add(first);
            this.add(second);
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return Collections.unmodifiableList(this.removedList);
        }

        @Override
        public List<CroisementChanges.Entry> getEntryList() {
            return Collections.unmodifiableList(this.entryList);
        }

        private void add(CroisementChanges croisementChanges) {
            this.removedList.addAll(croisementChanges.getRemovedList());
            this.entryList.addAll(croisementChanges.getEntryList());
        }
    }
}

