/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.misc;

import java.util.Locale;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;

public class ThesaurusMessageLocalisation
implements MessageLocalisation {
    private final Thesaurus thesaurus;
    private final ThesaurusLangChecker thesaurusLangChecker;
    private final Lang lang;
    private final Locale formatLocale;

    public ThesaurusMessageLocalisation(Thesaurus thesaurus, Lang lang, ThesaurusLangChecker thesaurusLangChecker, Locale formatLocale) {
        this.thesaurus = thesaurus;
        this.lang = lang;
        this.thesaurusLangChecker = thesaurusLangChecker;
        this.formatLocale = formatLocale;
    }

    @Override
    public String toString(String messageKey) {
        if (messageKey.isEmpty()) {
            return "";
        }
        Motcle motcle = this.thesaurus.getMotcleByIdalpha(messageKey = LocalisationUtils.cleanMessageKey(messageKey));
        if (motcle != null) {
            return this.checkLabelString(motcle, this.lang, messageKey);
        }
        return null;
    }

    @Override
    public String toString(Message message) {
        String messageKey = message.getMessageKey();
        if (messageKey.isEmpty()) {
            return LocalisationUtils.joinValues(message);
        }
        Motcle motcle = this.thesaurus.getMotcleByIdalpha(messageKey = LocalisationUtils.cleanMessageKey(messageKey));
        if (motcle != null) {
            try {
                return StringUtils.formatMessage(this.checkLabelString(motcle, this.lang, messageKey), message.getMessageValues(), this.formatLocale);
            }
            catch (StringUtils.FormatException fe) {
                return "[" + messageKey + "] " + fe.getMessage();
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(String messageKey) {
        Motcle motcle = this.thesaurus.getMotcleByIdalpha(messageKey = LocalisationUtils.cleanMessageKey(messageKey));
        return motcle != null;
    }

    private String checkLabelString(Motcle motcle, Lang lang, String messageKey) {
        Label label = motcle.getLabels().getLangPartCheckedLabel(lang);
        if (label == null) {
            label = LabelUtils.getFirstLabel(motcle.getLabels(), this.thesaurusLangChecker.getAuthorizedLangs(motcle.getThesaurus()));
        }
        if (label != null) {
            return label.getLabelString();
        }
        return messageKey;
    }
}

