/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.ThesaurusRowParser;
import net.fichotheque.tools.importation.thesaurus.RemoveThesaurusImportBuilder;

class ThesaurusRemoveRowParser
extends ThesaurusRowParser {
    private final int fieldIndex;
    private final boolean isIdalpha;
    private final RemoveThesaurusImportBuilder removeThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;

    private ThesaurusRemoveRowParser(RemoveThesaurusImportBuilder removeThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, int fieldIndex, boolean isIdalpha) {
        this.removeThesaurusImportBuilder = removeThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.fieldIndex = fieldIndex;
        this.isIdalpha = isIdalpha;
    }

    @Override
    public RemoveThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.removeThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        if (row.getColumnCount() <= this.fieldIndex) {
            this.parseResultBuilder.missingIdColumn(rowNumber);
            return;
        }
        String idString = row.getColumnValue(this.fieldIndex).trim();
        Thesaurus thesaurus = this.removeThesaurusImportBuilder.getThesaurus();
        Motcle motcle = null;
        if (this.isIdalpha) {
            motcle = thesaurus.getMotcleByIdalpha(idString);
            if (motcle == null) {
                this.parseResultBuilder.unknownIdalpha(rowNumber, idString);
            }
        } else {
            try {
                int id = Integer.parseInt(idString);
                motcle = thesaurus.getMotcleById(id);
                if (motcle == null) {
                    this.parseResultBuilder.unknownId(rowNumber, idString);
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.notIntegerId(rowNumber, idString);
            }
        }
        if (motcle != null) {
            this.removeThesaurusImportBuilder.add(motcle);
        }
    }

    static ThesaurusRemoveRowParser newInstance(String[] fieldArray, RemoveThesaurusImportBuilder removeThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        int fieldIndex = -1;
        int idalphaIndex = -1;
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            ThesaurusFieldKey thesaurusFieldKey;
            String field = fieldArray[i].trim();
            try {
                thesaurusFieldKey = ThesaurusFieldKey.parse(field);
            }
            catch (ParseException pe) {
                continue;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                if (fieldIndex != -1) continue;
                fieldIndex = i;
                continue;
            }
            if (!thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA) || idalphaIndex != -1) continue;
            idalphaIndex = i;
        }
        boolean isIdalpha = false;
        if (fieldIndex == -1) {
            if (removeThesaurusImportBuilder.getThesaurus().isIdalphaType()) {
                if (idalphaIndex != -1) {
                    fieldIndex = idalphaIndex;
                    isIdalpha = true;
                } else {
                    parseResultBuilder.missingColumns(ThesaurusFieldKey.ID.toString(), ThesaurusFieldKey.IDALPHA.toString());
                }
            } else {
                parseResultBuilder.missingColumn(ThesaurusFieldKey.ID.toString());
            }
        }
        if (fieldIndex != -1) {
            return new ThesaurusRemoveRowParser(removeThesaurusImportBuilder, parseResultBuilder, fieldIndex, isIdalpha);
        }
        return null;
    }
}

