/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.corpus;

import net.fichotheque.corpus.FicheChange;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.importation.LiensImport;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.LiensImportBuilder;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.primitives.FuzzyDate;

public class EditFicheImportBuilder {
    private final int ficheId;
    protected FicheChangeBuilder ficheChangeBuilder;
    protected AttributeChangeBuilder attributeChangeBuilder;
    protected LiensImportBuilder liensImportBuilder;
    protected FuzzyDate creationDate;

    public EditFicheImportBuilder(int ficheId) {
        this.ficheId = ficheId;
    }

    public EditFicheImportBuilder setCreationDate(FuzzyDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public FicheChangeBuilder getFicheChangeBuilder() {
        if (this.ficheChangeBuilder == null) {
            this.ficheChangeBuilder = new FicheChangeBuilder();
        }
        return this.ficheChangeBuilder;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        if (this.attributeChangeBuilder == null) {
            this.attributeChangeBuilder = new AttributeChangeBuilder();
        }
        return this.attributeChangeBuilder;
    }

    public LiensImportBuilder getLiensImportBuilder() {
        if (this.liensImportBuilder == null) {
            this.liensImportBuilder = new LiensImportBuilder();
        }
        return this.liensImportBuilder;
    }

    protected FicheChange getFicheChange() {
        if (this.ficheChangeBuilder == null) {
            return CorpusUtils.EMPTY_FICHECHANGE;
        }
        return this.ficheChangeBuilder.toFicheChange();
    }

    protected AttributeChange getAttributeChange() {
        if (this.attributeChangeBuilder == null) {
            return AttributeUtils.EMPTY_ATTRIBUTECHANGE;
        }
        return this.attributeChangeBuilder.toAttributeChange();
    }

    protected LiensImport getLiensImport() {
        if (this.liensImportBuilder == null) {
            return ImportationUtils.EMPTY_LIENSIMPORT;
        }
        return this.liensImportBuilder.toLiensImport();
    }

    public CorpusImport.EditFicheImport toEditFicheImport() {
        return new InternalEditFicheImport(this.ficheId, this.getFicheChange(), this.getAttributeChange(), this.getLiensImport(), this.creationDate);
    }

    public static EditFicheImportBuilder init(int ficheId) {
        return new EditFicheImportBuilder(ficheId);
    }

    private static class InternalEditFicheImport
    implements CorpusImport.EditFicheImport {
        private final int ficheId;
        private final FicheChange ficheChange;
        private final AttributeChange attributeChange;
        private final LiensImport liensImport;
        private final FuzzyDate creationDate;

        private InternalEditFicheImport(int ficheId, FicheChange ficheChange, AttributeChange attributeChange, LiensImport liensImport, FuzzyDate creationDate) {
            this.ficheId = ficheId;
            this.ficheChange = ficheChange;
            this.attributeChange = attributeChange;
            this.liensImport = liensImport;
            this.creationDate = creationDate;
        }

        @Override
        public int getFicheId() {
            return this.ficheId;
        }

        @Override
        public FicheChange getFicheChange() {
            return this.ficheChange;
        }

        @Override
        public AttributeChange getAttributeChange() {
            return this.attributeChange;
        }

        @Override
        public LiensImport getLiensImport() {
            return this.liensImport;
        }

        @Override
        public FuzzyDate getCreationDate() {
            return this.creationDate;
        }
    }
}

