/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;

public class ImagePropTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    ImagePropTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        if (!(ficheItem instanceof ImageItem)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        ImageItem image = (ImageItem)ficheItem;
        String subfieldString = this.getSubfieldString(image);
        if (subfieldString != null) {
            SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(subfieldString);
            String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
            return FormatterUtils.toTokens(value);
        }
        return FormatterUtils.EMPTY_TOKENS;
    }

    private String getSubfieldString(ImageItem image) {
        switch (this.subfieldKey.getSubtype()) {
            case "src": {
                return image.getSrc();
            }
            case "alt": {
                return image.getAlt();
            }
            case "title": {
                return image.getTitle();
            }
        }
        throw new SwitchException("subfieldType = " + this.subfieldKey.getSubtype());
    }
}

