/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.format.FormatSource;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.models.PersonCore;

public final class FormatterParserUtils {
    private FormatterParserUtils() {
    }

    public static boolean isUppercase(Instruction instruction) {
        for (Argument argument : instruction) {
            String key = argument.getKey();
            if (!key.equals("up")) continue;
            return true;
        }
        return false;
    }

    public static String toUppercase(String value, FormatSource formatSource) {
        return value.toUpperCase(formatSource.getDefaultFormatLocale());
    }

    public static PersonCore toPersonCore(FicheItem ficheItem, FormatSource formatSource) {
        return SphereUtils.toPersonCore(formatSource.getFichotheque(), (PersonItem)ficheItem);
    }

    public static Cell[] resolve(SubsetItem subsetItem, JsonParameters jsonParameters, FormatSource formatSource) {
        CellConverter cellConverter;
        Cell[] cellArray = null;
        String cellConverterName = jsonParameters.getCellConverterName();
        if (cellConverterName != null && (cellConverter = formatSource.getCellConverter(cellConverterName)) != null) {
            cellArray = cellConverter.toCellArray(subsetItem);
        }
        return cellArray;
    }
}

