/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.sql;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.sql.SqlExport;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.CroisementTable;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.tools.exportation.table.CroisementTableExportSqlWriter;
import net.fichotheque.tools.exportation.table.SqlTableWriter;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.sql.CreateTableWriter;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;

public class DefaultSqlExport
implements SqlExport {
    public static final String CHARSET_PARAMNAME = "charset";
    public static final String ENTITIES_PARAMNAME = "entities";
    public static final String DROPTABLE_PARAMNAME = "drop_table";
    public static final String DELETETABLE_PARAMNAME = "delete_table";
    public static final String CREATETABLE_PARAMNAME = "create_table";
    public static final String CREATEOPTIONS_PARAMNAME = "create_options";
    public static final int CREATE_TABLE = 1;
    public static final int DELETE_TABLE = 1;
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private TableExport tableExport;
    private TableExportContext tableExportContext;
    private ExtractionContext extractionContext;
    private CellConverter cellConverter;
    private Predicate<SubsetItem> predicate;

    @Override
    public void exportDump(OutputStream outputStream) throws IOException {
        String charset = this.paramMap.get(CHARSET_PARAMNAME);
        if (charset == null) {
            charset = "UTF-8";
        }
        try (OutputStreamWriter osw = new OutputStreamWriter(outputStream, charset);){
            Writer bufWriter = new BufferedWriter(osw);
            if (this.paramMap.get(ENTITIES_PARAMNAME) != null) {
                bufWriter = new NumericEntityWriter(bufWriter);
            }
            ExportProcess exportProcess = new ExportProcess(bufWriter);
            exportProcess.run();
            bufWriter.flush();
        }
    }

    @Override
    public void setTableExport(TableExport tableExport, TableExportContext tableExportContext) {
        this.tableExport = tableExport;
        this.tableExportContext = tableExportContext;
    }

    @Override
    public void setExtractionContext(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
    }

    @Override
    public void setParameter(String name, String value) {
        this.paramMap.put(name, value);
    }

    @Override
    public void setPredicate(Predicate<SubsetItem> predicate) {
        this.predicate = predicate;
    }

    @Override
    public void setCellConverter(CellConverter cellConverter) {
        this.cellConverter = cellConverter;
    }

    private ModeOption getModeOption(String paramName) {
        String value = this.paramMap.get(paramName);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        int mode = 1;
        String[] tokens = StringUtils.getTechnicalTokens(value, false);
        int length = tokens.length;
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String token = tokens[i];
                switch (token = token.toUpperCase()) {
                    case "2": 
                    case "IF EXISTS": 
                    case "MYSQL": {
                        mode = 2;
                    }
                }
            }
        }
        return new ModeOption((short)mode);
    }

    private CreateTableOption getCreateTableOption() {
        String value = this.paramMap.get(CREATETABLE_PARAMNAME);
        if (value == null) {
            return null;
        }
        int mode = 1;
        boolean withTitle = false;
        String[] tokens = StringUtils.getTechnicalTokens(value, false);
        int length = tokens.length;
        if (length > 0) {
            block11: for (int i = 0; i < length; ++i) {
                String token = tokens[i];
                switch (token = token.toUpperCase()) {
                    case "2": 
                    case "IF NOT EXISTS": 
                    case "MYSQL": {
                        mode = 2;
                        continue block11;
                    }
                    case "COMMENT": 
                    case "WITH_TITLE": {
                        withTitle = true;
                    }
                }
            }
        }
        return new CreateTableOption((short)mode, withTitle);
    }

    private static class CreateTableOption {
        private final short mode;
        private final boolean withTitle;

        private CreateTableOption(short mode, boolean withTitle) {
            this.mode = mode;
            this.withTitle = withTitle;
        }

        private short getMode() {
            return this.mode;
        }

        private boolean isWithTitle() {
            return this.withTitle;
        }
    }

    private static class ModeOption {
        private final short mode;

        private ModeOption(short mode) {
            this.mode = mode;
        }

        private short getMode() {
            return this.mode;
        }
    }

    private static class NumericEntityWriter
    extends Writer {
        private final Writer destination;

        private NumericEntityWriter(Writer destination) {
            this.destination = destination;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int codepoint;
            len = Math.min(cbuf.length, off + len);
            for (int pos = off; pos < len; pos += Character.charCount(codepoint)) {
                codepoint = Character.codePointAt(cbuf, pos);
                if (codepoint < 128) {
                    this.destination.write(cbuf[pos]);
                    continue;
                }
                this.destination.write("&#");
                this.destination.write(Integer.toString(codepoint, 10));
                this.destination.write(59);
            }
        }

        @Override
        public void close() throws IOException {
            this.destination.close();
        }

        @Override
        public void flush() throws IOException {
            this.destination.flush();
        }
    }

    private class ExportProcess {
        private final Writer writer;
        private final ModeOption deleteTableOption;
        private final ModeOption dropTableOption;
        private final CreateTableOption createTableOption;

        private ExportProcess(Writer writer) {
            this.writer = writer;
            this.dropTableOption = DefaultSqlExport.this.getModeOption(DefaultSqlExport.DROPTABLE_PARAMNAME);
            this.deleteTableOption = DefaultSqlExport.this.getModeOption(DefaultSqlExport.DELETETABLE_PARAMNAME);
            this.createTableOption = DefaultSqlExport.this.getCreateTableOption();
        }

        private void run() throws IOException {
            boolean next = false;
            for (SubsetTable table : DefaultSqlExport.this.tableExport.getSubsetTableList()) {
                if (next) {
                    this.blank();
                } else {
                    next = true;
                }
                Subset subset = table.getSubset();
                String tableName = table.getParameterValue("table_name");
                if (tableName == null) {
                    tableName = subset.getSubsetKeyString();
                }
                this.testDrop(tableName);
                if (this.createTableOption != null) {
                    this.writeCreateTable(tableName, table.getColDefList(), subset);
                    this.endLine();
                    this.blank();
                }
                this.testDelete(tableName);
                SqlTableWriter sqlTableWriter = new SqlTableWriter(this.writer, tableName);
                Collection<SubsetItem> subsetItems = FichothequeUtils.filterAndSort(subset, DefaultSqlExport.this.predicate);
                TableExportEngine.exportSubset(table, sqlTableWriter, DefaultSqlExport.this.cellConverter, subsetItems);
            }
            for (CroisementTable croisementTable : DefaultSqlExport.this.tableExport.getCroisementTableList()) {
                if (next) {
                    this.blank();
                } else {
                    next = true;
                }
                String tableName = croisementTable.getTableName();
                this.testDrop(tableName);
                this.testDelete(tableName);
                CroisementTableExportSqlWriter croisementTableExportSqlWriter = new CroisementTableExportSqlWriter(this.writer, tableName);
                TableExportEngine.exportCroisement(croisementTable, croisementTableExportSqlWriter);
            }
        }

        private void testDrop(String tableName) throws IOException {
            if (this.dropTableOption != null) {
                this.writer.write("DROP TABLE ");
                if (this.dropTableOption.getMode() == 2) {
                    this.writer.write("IF EXISTS");
                    this.writer.write(" ");
                }
                this.writer.write(tableName);
                this.endLine();
                this.blank();
            }
        }

        private void testDelete(String tableName) throws IOException {
            if (this.deleteTableOption != null) {
                this.writer.write("DELETE FROM ");
                this.writer.write(tableName);
                this.endLine();
                this.blank();
            }
        }

        public void endLine() throws IOException {
            this.writer.write(";\n");
        }

        public void blank() throws IOException {
            this.writer.write("\n");
        }

        private void writeCreateTable(String tableName, List<ColDef> colDefList, Subset subset) throws IOException {
            CreateTableWriter createTableWriter = new CreateTableWriter(this.writer, this.createTableOption.getMode());
            createTableWriter.startTable(tableName);
            block5: for (ColDef colDef : colDefList) {
                Labels labels;
                boolean isPrimary = false;
                String colName = colDef.getColName();
                if (colName.equals("id")) {
                    isPrimary = true;
                }
                String title = null;
                if (this.createTableOption.isWithTitle() && DefaultSqlExport.this.extractionContext.getLangContext() instanceof ListLangContext && (labels = TableDefUtils.getLabels(colDef, DefaultSqlExport.this.tableExportContext.getSourceLabelProvider(), subset)) != null) {
                    StringBuilder titleBuf = new StringBuilder();
                    for (ListLangContext.Unit unit : (ListLangContext)DefaultSqlExport.this.extractionContext.getLangContext()) {
                        Lang lang = unit.getLang();
                        Label label = labels.getLabel(lang);
                        if (label == null) continue;
                        if (titleBuf.length() > 0) {
                            titleBuf.append(" / ");
                        }
                        titleBuf.append(label.getLabelString());
                    }
                    if (titleBuf.length() > 0) {
                        title = titleBuf.toString();
                    }
                }
                switch (colDef.getCastType()) {
                    case 1: {
                        createTableWriter.addIntegerField(colName, isPrimary, title);
                        continue block5;
                    }
                    case 2: 
                    case 5: {
                        createTableWriter.addDoubleField(colName, isPrimary, title);
                        continue block5;
                    }
                    case 3: {
                        createTableWriter.addDateField(colName, isPrimary, title);
                        continue block5;
                    }
                }
                createTableWriter.addTextField(colName, isPrimary, title);
            }
            createTableWriter.endTable((String)DefaultSqlExport.this.paramMap.get(DefaultSqlExport.CREATEOPTIONS_PARAMNAME));
        }
    }
}

