/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.json;

import java.io.IOException;
import net.fichotheque.exportation.table.Cell;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.JSONString;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public final class CellJson {
    private CellJson() {
    }

    public static void properties(JSONWriter jw, Cell cell) throws IOException {
        Object obj = cell.getValue();
        if (obj != null) {
            jw.key(cell.getColDef().getColName());
            switch (cell.getFormatCast()) {
                case 1: {
                    jw.value((Long)obj);
                    break;
                }
                case 2: {
                    jw.value((Decimal)obj);
                    break;
                }
                case 3: {
                    jw.value(((FuzzyDate)obj).toString());
                    break;
                }
                case 4: {
                    jw.object();
                    Amount amount = (Amount)obj;
                    jw.key("currency").value(amount.getCurrencyCode());
                    jw.key("decimal").value(amount.toDecimal(true));
                    jw.key("long").value(amount.getMoneyLong());
                    jw.endObject();
                    break;
                }
                case 5: {
                    jw.value((Decimal)obj);
                    break;
                }
                case 6: {
                    jw.value(new InternalJSONString((String)obj));
                    break;
                }
                default: {
                    jw.value((String)obj);
                }
            }
        }
    }

    public static void cellArrayMappingProperty(JSONWriter jw, @Nullable Cell[] cellArray) throws IOException {
        CellJson.cellArrayMappingProperty(jw, cellArray, "properties");
    }

    public static void cellArrayMappingProperty(JSONWriter jw, @Nullable Cell[] cellArray, String propertyKey) throws IOException {
        jw.key(propertyKey);
        jw.object();
        if (cellArray != null) {
            for (Cell cell : cellArray) {
                CellJson.properties(jw, cell);
            }
        }
        jw.endObject();
    }

    public static void properties(JSONWriter jw, Cell[] cellArray) throws IOException {
        for (Cell cell : cellArray) {
            CellJson.properties(jw, cell);
        }
    }

    private static class InternalJSONString
    implements JSONString {
        private final String jsonString;

        private InternalJSONString(String jsonString) {
            this.jsonString = jsonString;
        }

        @Override
        public String toJSONString() {
            return this.jsonString;
        }
    }
}

