/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.impl.AbstractMotcle;
import net.fichotheque.impl.BabelienMotcle;
import net.fichotheque.impl.CorpusImpl;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.impl.Motcles;
import net.fichotheque.impl.MultiMotcle;
import net.fichotheque.impl.Satellites;
import net.fichotheque.impl.ThesaurusDataSource;
import net.fichotheque.impl.ThesaurusMetadataImpl;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.collation.map.SortedCollatedKeyMap;

class ThesaurusImpl
implements Thesaurus {
    private final SubsetKey thesaurusKey;
    private final FichothequeImpl fichotheque;
    private final short thesaurusType;
    private final Map<String, Motcle> idalphaMap;
    private final SortedCollatedKeyMap<List<Motcle>> babelienMap;
    private final Map<Lang, SortedCollatedKeyMap<List<Motcle>>> labelMaps;
    private final Satellites satellites = new Satellites();
    private final Motcles firstLevelMotcles = new Motcles();
    private final Map<Integer, AbstractMotcle> itemMap = new HashMap<Integer, AbstractMotcle>();
    private ThesaurusMetadataImpl thesaurusMetadata;
    private int availableId = 1;
    private List<SubsetItem> cacheSubsetItemList;
    private List<Motcle> cacheList;

    private ThesaurusImpl(SubsetKey thesaurusKey, short thesaurusType, FichothequeImpl fichotheque) {
        this.thesaurusKey = thesaurusKey;
        this.fichotheque = fichotheque;
        this.thesaurusType = thesaurusType;
        this.idalphaMap = thesaurusType == 2 ? new HashMap<String, Motcle>() : null;
        if (thesaurusType == 3) {
            this.babelienMap = new SortedCollatedKeyMap(Locale.FRENCH);
            this.labelMaps = null;
        } else {
            this.babelienMap = null;
            this.labelMaps = new HashMap<Lang, SortedCollatedKeyMap<List<Motcle>>>();
        }
    }

    static InitEditor fromInit(SubsetKey thesaurusKey, short thesaurusType, FichothequeImpl fichotheque, FichothequeImpl.InitEditor fichothequeInitEditor) {
        ThesaurusImpl thesaurus = new ThesaurusImpl(thesaurusKey, thesaurusType, fichotheque);
        return new InitEditor(thesaurus, fichothequeInitEditor);
    }

    static ThesaurusImpl fromNew(SubsetKey thesaurusKey, short thesaurusType, FichothequeImpl fichotheque) {
        ThesaurusImpl thesaurus = new ThesaurusImpl(thesaurusKey, thesaurusType, fichotheque);
        thesaurus.thesaurusMetadata = ThesaurusMetadataImpl.fromNew(thesaurus);
        return thesaurus;
    }

    @Override
    public Metadata getMetadata() {
        return this.thesaurusMetadata;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public SubsetKey getSubsetKey() {
        return this.thesaurusKey;
    }

    @Override
    public SubsetItem getSubsetItemById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public List<Motcle> getMotcleList() {
        List<Motcle> result = this.cacheList;
        if (result == null) {
            result = this.initMotcleList();
        }
        return result;
    }

    @Override
    public List<SubsetItem> getSubsetItemList() {
        List<SubsetItem> list = this.cacheSubsetItemList;
        if (list == null) {
            list = this.initSubsetItemList();
        }
        return list;
    }

    @Override
    public List<Motcle> getFirstLevelList() {
        return this.firstLevelMotcles.getCache();
    }

    @Override
    public Motcle getMotcleById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public Motcle getMotcleByIdalpha(String idalpha) {
        if (this.idalphaMap == null) {
            throw new UnsupportedOperationException("thesarus has no idalpha");
        }
        return this.idalphaMap.get(idalpha);
    }

    @Override
    public Motcle getMotcleByLabel(String labelString, Lang lang) {
        SortedCollatedKeyMap<List<Motcle>> map = this.getLabelMap(lang);
        List<Motcle> liste = map.getValue(labelString);
        if (liste == null) {
            return null;
        }
        return liste.get(0);
    }

    @Override
    public List<Corpus> getSatelliteCorpusList() {
        return this.satellites.getCache();
    }

    Motcles getFirstLevelMotcleList() {
        return this.firstLevelMotcles;
    }

    short getThesaurusType() {
        return this.thesaurusType;
    }

    void addSatelliteCorpus(CorpusImpl bdfimplCorpus) {
        this.satellites.add(bdfimplCorpus);
    }

    void removeSatelliteCorpus(CorpusImpl bdfimplCorpus) {
        this.satellites.remove(bdfimplCorpus);
    }

    ThesaurusEditorImpl getThesaurusEditor(FichothequeEditor fichothequeEditor) {
        return new ThesaurusEditorImpl(fichothequeEditor);
    }

    private synchronized Motcle innerCreateMotcle(int id, String idalpha) throws ExistingIdException, ParseException {
        if (id < 1) {
            id = this.availableId;
        } else if (this.itemMap.containsKey(id)) {
            throw new ExistingIdException();
        }
        if (this.idalphaMap != null) {
            if (idalpha == null || idalpha.length() == 0) {
                idalpha = "_" + id;
                while (this.idalphaMap.get(idalpha) != null) {
                    idalpha = idalpha + "_";
                }
            } else {
                Idalpha.test(idalpha);
                if (this.idalphaMap.get(idalpha) != null) {
                    throw new ExistingIdException();
                }
            }
        } else {
            idalpha = null;
        }
        AbstractMotcle motcle = this.thesaurusType == 3 ? new BabelienMotcle(this, id) : new MultiMotcle(this, id);
        if (idalpha != null) {
            motcle.setIdalpha(idalpha);
            this.idalphaMap.put(idalpha, motcle);
        }
        this.itemMap.put(id, motcle);
        this.addInFirstLevel(motcle);
        this.availableId = Math.max(this.availableId, id + 1);
        this.clearCache();
        return motcle;
    }

    private synchronized boolean innerRemoveMotcle(Motcle motcle) {
        AbstractMotcle am = this.testMotcle(motcle);
        if (!this.fichotheque.isRemoveable(am)) {
            return false;
        }
        int id = motcle.getId();
        am.removeFromParent();
        if (this.idalphaMap != null) {
            this.idalphaMap.remove(am.getIdalpha());
        }
        for (Label label : am.getLabels()) {
            SortedCollatedKeyMap<List<Motcle>> map = this.getLabelMap(label.getLang());
            this.remove(map, label.getLabelString(), am);
        }
        this.itemMap.remove(id);
        this.clearCache();
        return true;
    }

    private synchronized boolean innerSetChildIndex(Motcle motcle, int index) {
        AbstractMotcle am = this.testMotcle(motcle);
        boolean done = am.changeIndex(index);
        if (done) {
            this.clearCache();
        }
        return done;
    }

    private synchronized boolean innerSetIdalpha(Motcle motcle, String newIdalpha) throws ExistingIdException, ParseException {
        if (this.idalphaMap == null) {
            throw new UnsupportedOperationException("this is not a thesaurus with idalpha");
        }
        Idalpha.test(newIdalpha);
        AbstractMotcle am = this.testMotcle(motcle);
        Motcle obj = this.idalphaMap.get(newIdalpha);
        if (obj != null) {
            if (!obj.equals(am)) {
                throw new ExistingIdException();
            }
            return false;
        }
        String oldIdalpha = am.getIdalpha();
        boolean done = am.setIdalpha(newIdalpha);
        if (done) {
            this.idalphaMap.remove(oldIdalpha);
            this.idalphaMap.put(newIdalpha, motcle);
        }
        return done;
    }

    private boolean innerPutLabel(Motcle motcle, Label label) {
        AbstractMotcle am = this.testMotcle(motcle);
        Lang lang = label.getLang();
        Label oldLabel = am.getLabels().getLabel(lang);
        boolean done = am.putLabel(label);
        if (done) {
            SortedCollatedKeyMap<List<Motcle>> map = this.getLabelMap(lang);
            if (oldLabel != null) {
                this.remove(map, oldLabel.getLabelString(), am);
            }
            this.add(map, label.getLabelString(), am);
        }
        return done;
    }

    private boolean innerRemoveLabel(Motcle motcle, Lang lang) {
        AbstractMotcle am = this.testMotcle(motcle);
        Label oldLabel = am.getLabels().getLabel(lang);
        boolean done = am.removeLabel(lang);
        if (done && oldLabel != null) {
            SortedCollatedKeyMap<List<Motcle>> map = this.getLabelMap(lang);
            this.remove(map, oldLabel.getLabelString(), am);
        }
        return done;
    }

    private synchronized boolean innerSetParent(Motcle motcle, Motcle parentMotcle) throws ParentRecursivityException {
        boolean done;
        AbstractMotcle am = this.testMotcle(motcle);
        if (parentMotcle == null) {
            done = am.setParent(null);
        } else {
            AbstractMotcle amparent = this.testMotcle(parentMotcle);
            if (am.equals(amparent)) {
                throw new IllegalArgumentException("motcle and parentMotcle are the same");
            }
            if (ThesaurusUtils.isDescendant(amparent, am)) {
                throw new ParentRecursivityException(am, amparent);
            }
            done = am.setParent(amparent);
        }
        if (done) {
            this.clearCache();
        }
        return done;
    }

    private boolean innerSetStatus(Motcle motcle, String status) {
        AbstractMotcle am = this.testMotcle(motcle);
        boolean done = am.setStatus(status);
        return done;
    }

    private synchronized void clearCache() {
        this.cacheSubsetItemList = null;
        this.cacheList = null;
    }

    private synchronized List<SubsetItem> initSubsetItemList() {
        TreeMap<Integer, AbstractMotcle> sortedMap = new TreeMap<Integer, AbstractMotcle>();
        sortedMap.putAll(this.itemMap);
        List<SubsetItem> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Motcle[sortedMap.size()]));
        this.cacheSubsetItemList = list;
        return list;
    }

    private synchronized List<Motcle> initMotcleList() {
        ArrayList<Motcle> list = new ArrayList<Motcle>();
        for (Motcle motcle : this.firstLevelMotcles.getCache()) {
            this.addInList(list, motcle);
        }
        this.cacheList = list;
        return list;
    }

    private void addInList(List<Motcle> list, Motcle motcle) {
        list.add(motcle);
        for (Motcle child : motcle.getChildList()) {
            this.addInList(list, child);
        }
    }

    void removeFromFirstLevel(int index) {
        this.firstLevelMotcles.remove(index);
    }

    void addInFirstLevel(AbstractMotcle motcle) {
        this.firstLevelMotcles.add(motcle);
    }

    private AbstractMotcle testMotcle(Motcle motcle) {
        if (motcle == null) {
            throw new IllegalArgumentException("motcle argument cannot be null");
        }
        try {
            AbstractMotcle am = (AbstractMotcle)motcle;
            if (am.getThesaurus() != this) {
                throw new IllegalArgumentException("motcle argument does not come from this thesaurus");
            }
            return am;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("motcle argument does not come from this thesaurus");
        }
    }

    private void remove(SortedCollatedKeyMap map, String lib, Object obj) {
        List liste = (List)map.getValue(lib);
        if (liste.size() == 1) {
            if (!liste.get(0).equals(obj)) {
                throw new IllegalStateException(obj.toString() + " does not match " + liste.get(0));
            }
            map.removeValue(lib);
        } else {
            liste.remove(obj);
        }
    }

    private void add(SortedCollatedKeyMap<List<Motcle>> map, String lib, Motcle motcle) {
        List<Motcle> liste = map.getValue(lib);
        if (liste == null) {
            map.putValue(lib, Collections.singletonList(motcle));
        } else if (liste.size() == 1) {
            ArrayList<Motcle> newList = new ArrayList<Motcle>();
            newList.add(liste.get(0));
            newList.add(motcle);
            map.putValue(lib, newList);
        } else {
            liste.add(motcle);
        }
    }

    private SortedCollatedKeyMap<List<Motcle>> getLabelMap(Lang lang) {
        if (this.babelienMap != null) {
            return this.babelienMap;
        }
        SortedCollatedKeyMap<List<Motcle>> map = this.labelMaps.get(lang);
        if (map == null) {
            map = new SortedCollatedKeyMap(lang.toLocale());
            this.labelMaps.put(lang, map);
        }
        return map;
    }

    static class InitEditor
    implements ThesaurusEditor {
        private final ThesaurusImpl thesaurus;
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final ThesaurusMetadataImpl.InitEditor metadataInitEditor;

        private InitEditor(ThesaurusImpl thesaurus, FichothequeImpl.InitEditor fichothequeInitEditor) {
            this.thesaurus = thesaurus;
            this.fichothequeInitEditor = fichothequeInitEditor;
            this.metadataInitEditor = ThesaurusMetadataImpl.fromInit(this);
            thesaurus.thesaurusMetadata = (ThesaurusMetadataImpl)this.metadataInitEditor.getMetadata();
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeInitEditor;
        }

        @Override
        public ThesaurusMetadataEditor getThesaurusMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public Motcle createMotcle(int id, String idalpha) throws ExistingIdException, ParseException {
            return this.thesaurus.innerCreateMotcle(id, idalpha);
        }

        @Override
        public boolean removeMotcle(Motcle motcle) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean setChildIndex(Motcle motcle, int index) {
            return this.thesaurus.innerSetChildIndex(motcle, index);
        }

        @Override
        public boolean setIdalpha(Motcle motcle, String newIdalpha) throws ExistingIdException, ParseException {
            return this.thesaurus.innerSetIdalpha(motcle, newIdalpha);
        }

        @Override
        public boolean putLabel(Motcle motcle, Label label) {
            return this.thesaurus.innerPutLabel(motcle, label);
        }

        @Override
        public boolean removeLabel(Motcle motcle, Lang lang) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean setParent(Motcle motcle, Motcle parentMotcle) throws ParentRecursivityException {
            return this.thesaurus.innerSetParent(motcle, parentMotcle);
        }

        @Override
        public boolean setStatus(Motcle motcle, String status) {
            return this.thesaurus.innerSetStatus(motcle, status);
        }
    }

    class ThesaurusEditorImpl
    implements ThesaurusEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<Integer> changedMotcleSet = new HashSet<Integer>();
        private final Set<Integer> removedMotcleSet = new HashSet<Integer>();
        private ThesaurusMetadataEditor thesaurusMetadataEditor;
        private boolean treeChanged = false;
        private boolean metadataChanged = false;

        private ThesaurusEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public Thesaurus getThesaurus() {
            return ThesaurusImpl.this;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public ThesaurusMetadataEditor getThesaurusMetadataEditor() {
            if (this.thesaurusMetadataEditor == null) {
                this.thesaurusMetadataEditor = ThesaurusImpl.this.thesaurusMetadata.getThesaurusMetadataEditor(this);
            }
            return this.thesaurusMetadataEditor;
        }

        @Override
        public Motcle createMotcle(int id, String idalpha) throws ExistingIdException, ParseException {
            Motcle motcle = ThesaurusImpl.this.innerCreateMotcle(id, idalpha);
            this.addMotcleChange(id);
            this.setTreeChange();
            return motcle;
        }

        @Override
        public boolean removeMotcle(Motcle motcle) {
            int id = motcle.getId();
            boolean done = ThesaurusImpl.this.innerRemoveMotcle(motcle);
            if (done) {
                this.removedMotcleSet.add(id);
                this.setTreeChange();
            }
            return done;
        }

        @Override
        public boolean setChildIndex(Motcle motcle, int index) {
            boolean done = ThesaurusImpl.this.innerSetChildIndex(motcle, index);
            if (done) {
                this.setTreeChange();
            }
            return done;
        }

        @Override
        public boolean setIdalpha(Motcle motcle, String newIdalpha) throws ExistingIdException, ParseException {
            boolean done = ThesaurusImpl.this.innerSetIdalpha(motcle, newIdalpha);
            if (done) {
                this.setTreeChange();
            }
            return done;
        }

        @Override
        public boolean putLabel(Motcle motcle, Label label) {
            boolean done = ThesaurusImpl.this.innerPutLabel(motcle, label);
            if (done) {
                this.addMotcleChange(motcle.getId());
            }
            return done;
        }

        @Override
        public boolean removeLabel(Motcle motcle, Lang lang) {
            boolean done = ThesaurusImpl.this.innerRemoveLabel(motcle, lang);
            if (done) {
                this.addMotcleChange(motcle.getId());
            }
            return done;
        }

        @Override
        public boolean setParent(Motcle motcle, Motcle parentMotcle) throws ParentRecursivityException {
            boolean done = ThesaurusImpl.this.innerSetParent(motcle, parentMotcle);
            if (done) {
                this.setTreeChange();
            }
            return done;
        }

        @Override
        public boolean setStatus(Motcle motcle, String status) {
            boolean done = ThesaurusImpl.this.innerSetStatus(motcle, status);
            if (done) {
                this.setTreeChange();
            }
            return done;
        }

        void addMotcleChange(int id) {
            this.changedMotcleSet.add(id);
        }

        void setTreeChange() {
            this.treeChanged = true;
        }

        void setMetadataChange() {
            this.metadataChanged = true;
        }

        void saveChanges() {
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            ThesaurusDataSource thesaurusDataSource = ThesaurusImpl.this.fichotheque.getFichothequeDataSource().getThesaurusDataSource();
            for (Integer id : this.changedMotcleSet) {
                Motcle motcle = ThesaurusImpl.this.getMotcleById(id);
                if (motcle == null) continue;
                thesaurusDataSource.saveMotcle(motcle, editOrigin);
            }
            this.changedMotcleSet.clear();
            for (Integer id : this.removedMotcleSet) {
                thesaurusDataSource.removeMotcle(ThesaurusImpl.this, id, editOrigin);
            }
            this.removedMotcleSet.clear();
            if (this.treeChanged) {
                thesaurusDataSource.saveTree(ThesaurusImpl.this, editOrigin);
                this.treeChanged = false;
            }
            if (this.metadataChanged) {
                thesaurusDataSource.saveMetadata(ThesaurusImpl.this, editOrigin);
                this.metadataChanged = false;
            }
        }
    }
}

