/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.impl.CorpusImpl;
import net.fichotheque.utils.FichothequeUtils;

class Satellites {
    private final List<Corpus> list = new ArrayList<Corpus>();
    private List<Corpus> cacheList = null;

    Satellites() {
    }

    List<Corpus> getCache() {
        List<Corpus> result = this.cacheList;
        if (result == null) {
            result = this.initCache();
        }
        return result;
    }

    synchronized void add(CorpusImpl corpus) {
        this.list.add(corpus);
        this.clearCache();
    }

    synchronized void remove(CorpusImpl corpus) {
        this.list.remove(corpus);
        this.clearCache();
    }

    private synchronized List<Corpus> initCache() {
        if (this.cacheList != null) {
            return this.cacheList;
        }
        List<Corpus> newCacheList = FichothequeUtils.wrap(this.list.toArray(new Corpus[this.list.size()]));
        this.cacheList = newCacheList;
        return newCacheList;
    }

    private void clearCache() {
        this.cacheList = null;
    }
}

