/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.session;

import fr.exemole.bdfserver.api.session.LoginException;
import fr.exemole.bdfserver.api.session.LoginParameters;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.request.RequestMap;

public class LoginParametersBuilder {
    private String formAction = "";
    private String reversePath = "";
    private LoginException loginException;
    private RequestMap requestMap;
    private CommandMessage commandMessage;
    private final Set<SubsetKey> loginSphereKeySet = new LinkedHashSet<SubsetKey>();
    private SubsetKey defaultSphereKey;
    private String titlePhraseName;

    public LoginParametersBuilder setFormAction(String formAction) {
        this.formAction = formAction;
        return this;
    }

    public LoginParametersBuilder setReversePath(String reversePath) {
        this.reversePath = reversePath;
        return this;
    }

    public LoginParametersBuilder setLoginException(LoginException loginException) {
        this.loginException = loginException;
        return this;
    }

    public LoginParametersBuilder setRequestMap(RequestMap requestMap) {
        this.requestMap = requestMap;
        return this;
    }

    public LoginParametersBuilder setCommandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
        return this;
    }

    public LoginParametersBuilder addLoginSphereKey(String sphereName) throws ParseException {
        SubsetKey sphereKey = SubsetKey.parse((short)3, sphereName);
        this.loginSphereKeySet.add(sphereKey);
        return this;
    }

    public LoginParametersBuilder addLoginSphereKey(SubsetKey loginSphereKey) {
        if (!loginSphereKey.isSphereSubset()) {
            throw new IllegalArgumentException("!loginSphereKey.isSphereSubset()");
        }
        this.loginSphereKeySet.add(loginSphereKey);
        return this;
    }

    public LoginParametersBuilder setDefaultSphereKey(SubsetKey defaultSphereKey) {
        if (defaultSphereKey != null && !defaultSphereKey.isSphereSubset()) {
            throw new IllegalArgumentException("!loginSphereKey.isSphereSubset()");
        }
        this.defaultSphereKey = defaultSphereKey;
        return this;
    }

    public LoginParametersBuilder setTitlePhraseName(String titlePhraseName) {
        this.titlePhraseName = titlePhraseName;
        return this;
    }

    public LoginParameters toLoginParameters() {
        List<SubsetKey> finalList = FichothequeUtils.toList(this.loginSphereKeySet);
        return new InternalLoginParameters(this.formAction, this.reversePath, this.loginException, this.requestMap, this.commandMessage, finalList, this.defaultSphereKey, this.titlePhraseName);
    }

    public static LoginParametersBuilder init() {
        return new LoginParametersBuilder();
    }

    private static class InternalLoginParameters
    implements LoginParameters {
        private final String formAction;
        private final String reversePath;
        private final LoginException loginException;
        private final RequestMap requestMap;
        private final CommandMessage commandMessage;
        private final List<SubsetKey> loginSphereKeyList;
        private final SubsetKey defaultSphereKey;
        private final String titlePhraseName;

        private InternalLoginParameters(String formAction, String reversePath, LoginException loginException, RequestMap requestMap, CommandMessage commandMessage, List<SubsetKey> loginSphereKeyList, SubsetKey defaultSphereKey, String titlePhraseName) {
            this.formAction = formAction;
            this.reversePath = reversePath;
            this.loginException = loginException;
            this.requestMap = requestMap;
            this.commandMessage = commandMessage;
            this.loginSphereKeyList = loginSphereKeyList;
            this.defaultSphereKey = defaultSphereKey;
            this.titlePhraseName = titlePhraseName;
        }

        @Override
        public String getFormAction() {
            return this.formAction;
        }

        @Override
        public String getReversePath() {
            return this.reversePath;
        }

        @Override
        public LoginException getLoginException() {
            return this.loginException;
        }

        @Override
        public RequestMap getRequestMap() {
            return this.requestMap;
        }

        @Override
        public CommandMessage getCommandMessage() {
            return this.commandMessage;
        }

        @Override
        public List<SubsetKey> getLoginSphrereKeyList() {
            return this.loginSphereKeyList;
        }

        @Override
        public SubsetKey getDefaultSphereKey() {
            return this.defaultSphereKey;
        }

        @Override
        public String getTitlePhraseName() {
            return this.titlePhraseName;
        }
    }
}

